"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateParamsSchema = exports.updateBodySchema = exports.actionSchema = exports.actionFrequencySchema = exports.actionAlertsFilterSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _responseOpsRuleParams = require("@kbn/response-ops-rule-params");
var _validation = require("../../../validation");
var _response = require("../../../response");
var _alerts_filter_query = require("../../../../alerts_filter_query");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionFrequencySchema = exports.actionFrequencySchema = _configSchema.schema.object({
  summary: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the action is a summary.'
    }
  }),
  notify_when: _response.notifyWhenSchemaV1,
  throttle: _configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDurationV1,
    meta: {
      description: 'The throttle interval, which defines how often an alert generates repeated actions. It is specified in seconds, minutes, hours, or days and is applicable only if `notify_when` is set to `onThrottleInterval`. NOTE: You cannot specify the throttle interval at both the rule and action level. The recommended method is to set it for each action. If you set it at the rule level then update the rule in Kibana, it is automatically changed to use action-specific values.'
    }
  }))
});
const actionAlertsFilterSchema = exports.actionAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_alerts_filter_query.alertsFilterQuerySchemaV1),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)]), {
      meta: {
        description: 'Defines the days of the week that the action can run, represented as an array of numbers. For example, `1` represents Monday. An empty array is equivalent to specifying all the days of the week.'
      }
    }),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string({
        validate: _validation.validateHoursV1,
        meta: {
          description: 'The start of the time frame in 24-hour notation (`hh:mm`).'
        }
      }),
      end: _configSchema.schema.string({
        validate: _validation.validateHoursV1,
        meta: {
          description: 'The end of the time frame in 24-hour notation (`hh:mm`).'
        }
      })
    }, {
      meta: {
        description: 'Defines the range of time in a day that the action can run. If the `start` value is `00:00` and the `end` value is `24:00`, actions be generated all day.'
      }
    }),
    timezone: _configSchema.schema.string({
      validate: _validation.validateTimezoneV1,
      meta: {
        description: 'The ISO time zone for the `hours` values. Values such as `UTC` and `UTC+1` also work but lack built-in daylight savings time support and are not recommended.'
      }
    })
  }, {
    meta: {
      description: 'Defines a period that limits whether the action runs.'
    }
  }))
});
const actionSchema = exports.actionSchema = _configSchema.schema.object({
  group: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: "The group name, which affects when the action runs (for example, when the threshold is met or when the alert is recovered). Each rule type has a list of valid action group names. If you don't need to group actions, set to `default`."
    }
  })),
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the connector saved object.'
    }
  }),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {},
    meta: {
      description: 'The parameters for the action, which are sent to the connector. The `params` are handled as Mustache templates and passed a default set of context.'
    }
  }),
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  uuid: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'A universally unique identifier (UUID) for the action.'
    }
  })),
  alerts_filter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  use_alert_data_for_template: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether to use alert data as a template.'
    }
  }))
}, {
  meta: {
    description: 'An action that runs under defined conditions.'
  }
});
const updateBodySchema = exports.updateBodySchema = _configSchema.schema.object({
  name: _configSchema.schema.string({
    meta: {
      description: 'The name of the rule. While this name does not have to be unique, a distinctive name can help you identify a rule.'
    }
  }),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'The tags for the rule.'
    }
  }), {
    defaultValue: []
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDurationV1,
      meta: {
        description: 'The interval is specified in seconds, minutes, hours, or days.'
      }
    })
  }),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDurationV1,
    meta: {
      description: 'Use the `throttle` property in the action `frequency` object instead. The throttle interval, which defines how often an alert generates repeated actions. NOTE: You cannot specify the throttle interval at both the rule and action level. If you set it at the rule level then update the rule in Kibana, it is automatically changed to use action-specific values.'
    }
  }))),
  params: _responseOpsRuleParams.ruleParamsSchemaWithDefaultValueV1,
  actions: _configSchema.schema.arrayOf(actionSchema, {
    defaultValue: []
  }),
  notify_when: _configSchema.schema.maybe(_configSchema.schema.nullable(_response.notifyWhenSchemaV1)),
  alert_delay: _configSchema.schema.maybe(_response.alertDelaySchemaV1),
  flapping: _configSchema.schema.maybe(_configSchema.schema.nullable(_common.flappingSchemaV1))
});
const updateParamsSchema = exports.updateParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the rule.'
    }
  })
});