"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeChangePointControls = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeChangePointControls = rawState => {
  const viewType = new _rxjs.BehaviorSubject(rawState.viewType);
  const dataViewId = new _rxjs.BehaviorSubject(rawState.dataViewId);
  const fn = new _rxjs.BehaviorSubject(rawState.fn);
  const metricField = new _rxjs.BehaviorSubject(rawState.metricField);
  const splitField = new _rxjs.BehaviorSubject(rawState.splitField);
  const partitions = new _rxjs.BehaviorSubject(rawState.partitions);
  const maxSeriesToPlot = new _rxjs.BehaviorSubject(rawState.maxSeriesToPlot);
  const updateUserInput = update => {
    viewType.next(update.viewType);
    dataViewId.next(update.dataViewId);
    fn.next(update.fn);
    metricField.next(update.metricField);
    splitField.next(update.splitField);
    partitions.next(update.partitions);
    maxSeriesToPlot.next(update.maxSeriesToPlot);
  };
  const serializeChangePointChartState = () => {
    return {
      viewType: viewType.getValue(),
      dataViewId: dataViewId.getValue(),
      fn: fn.getValue(),
      metricField: metricField.getValue(),
      splitField: splitField.getValue(),
      partitions: partitions.getValue(),
      maxSeriesToPlot: maxSeriesToPlot.getValue()
    };
  };
  const changePointControlsComparators = {
    viewType: [viewType, arg => viewType.next(arg)],
    dataViewId: [dataViewId, arg => dataViewId.next(arg)],
    fn: [fn, arg => fn.next(arg)],
    metricField: [metricField, arg => metricField.next(arg)],
    splitField: [splitField, arg => splitField.next(arg)],
    partitions: [partitions, arg => partitions.next(arg), _fastDeepEqual.default],
    maxSeriesToPlot: [maxSeriesToPlot, arg => maxSeriesToPlot.next(arg)]
  };
  return {
    changePointControlsApi: {
      viewType,
      dataViewId,
      fn,
      metricField,
      splitField,
      partitions,
      maxSeriesToPlot,
      updateUserInput
    },
    serializeChangePointChartState,
    changePointControlsComparators
  };
};
exports.initializeChangePointControls = initializeChangePointControls;