"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transparent_background_colors = exports.text_colors = exports.special_colors = exports.shade_colors = exports.light_colors = exports.dark_transparent_background_colors = exports.dark_shades = exports.dark_colors_ams = exports.dark_border_colors = exports.dark_background_colors = exports.colors = exports.brand_text_colors = exports.brand_colors = exports.border_colors = exports.background_colors = void 0;
var _manipulation = require("../../../../services/color/manipulation");
var _utils = require("../../../../services/theme/utils");
var _contrast = require("../../../../services/color/contrast");
var _colors_vis = require("./_colors_vis");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/*
 * LIGHT THEME
 * Only split up in the light theme to access the keys by section in the docs
 */

var brand_colors = exports.brand_colors = {
  primary: '#0077CC',
  accent: '#F04E98',
  accentSecondary: '#00BFB3',
  success: '#00BFB3',
  warning: '#FEC514',
  danger: '#BD271E'
};
var brand_text_colors = exports.brand_text_colors = {
  primaryText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.primary')),
  accentText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.accent')),
  successText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.success')),
  warningText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.warning')),
  dangerText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.danger')),
  textPrimary: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.primary')),
  textAccent: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.accent')),
  textAccentSecondary: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.success')),
  textSuccess: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.success')),
  textWarning: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.warning')),
  textDanger: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.danger'))
};
var shade_colors = exports.shade_colors = {
  emptyShade: '#FFFFFF',
  lightestShade: '#F1F4FA',
  lightShade: '#D3DAE6',
  mediumShade: '#98A2B3',
  darkShade: '#69707D',
  darkestShade: '#343741',
  fullShade: '#000000'
};
var special_colors = exports.special_colors = {
  body: (0, _utils.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      lightestShade = _ref2[0];
    return (0, _manipulation.tint)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  highlight: (0, _utils.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
      warning = _ref4[0];
    return (0, _manipulation.tint)(warning, 0.9);
  }, ['colors.warning']),
  disabled: '#ABB4C4',
  disabledText: (0, _utils.computed)((0, _contrast.makeDisabledContrastColor)('colors.disabled')),
  shadow: (0, _utils.computed)(function (_ref5) {
    var colors = _ref5.colors;
    return colors.ink;
  })
};
var text_colors = exports.text_colors = {
  text: (0, _utils.computed)(function (_ref6) {
    var _ref7 = _slicedToArray(_ref6, 1),
      darkestShade = _ref7[0];
    return darkestShade;
  }, ['colors.darkestShade']),
  title: (0, _utils.computed)(function (_ref8) {
    var _ref9 = _slicedToArray(_ref8, 1),
      text = _ref9[0];
    return (0, _manipulation.shade)(text, 0.5);
  }, ['colors.text']),
  subduedText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.darkShade')),
  link: (0, _utils.computed)(function (_ref10) {
    var _ref11 = _slicedToArray(_ref10, 1),
      primaryText = _ref11[0];
    return primaryText;
  }, ['colors.primaryText']),
  textParagraph: (0, _utils.computed)(function (_ref12) {
    var _ref13 = _slicedToArray(_ref12, 1),
      darkestShade = _ref13[0];
    return darkestShade;
  }, ['colors.darkestShade']),
  textHeading: (0, _utils.computed)(function (_ref14) {
    var _ref15 = _slicedToArray(_ref14, 1),
      text = _ref15[0];
    return (0, _manipulation.shade)(text, 0.5);
  }, ['colors.text']),
  textSubdued: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.darkShade')),
  textDisabled: (0, _utils.computed)((0, _contrast.makeDisabledContrastColor)('colors.disabled')),
  textInverse: (0, _utils.computed)(function (_ref16) {
    var _ref17 = _slicedToArray(_ref16, 1),
      ghost = _ref17[0];
    return ghost;
  }, ['colors.ghost'])
};
var background_colors = exports.background_colors = {
  backgroundBasePrimary: (0, _utils.computed)(function (_ref18) {
    var _ref19 = _slicedToArray(_ref18, 1),
      primary = _ref19[0];
    return (0, _manipulation.tint)(primary, 0.9);
  }, ['colors.primary']),
  backgroundBaseAccent: (0, _utils.computed)(function (_ref20) {
    var _ref21 = _slicedToArray(_ref20, 1),
      accent = _ref21[0];
    return (0, _manipulation.tint)(accent, 0.9);
  }, ['colors.accent']),
  backgroundBaseAccentSecondary: (0, _utils.computed)(function (_ref22) {
    var _ref23 = _slicedToArray(_ref22, 1),
      success = _ref23[0];
    return (0, _manipulation.tint)(success, 0.9);
  }, ['colors.success']),
  backgroundBaseSuccess: (0, _utils.computed)(function (_ref24) {
    var _ref25 = _slicedToArray(_ref24, 1),
      success = _ref25[0];
    return (0, _manipulation.tint)(success, 0.9);
  }, ['colors.success']),
  backgroundBaseWarning: (0, _utils.computed)(function (_ref26) {
    var _ref27 = _slicedToArray(_ref26, 1),
      warning = _ref27[0];
    return (0, _manipulation.tint)(warning, 0.9);
  }, ['colors.warning']),
  backgroundBaseDanger: (0, _utils.computed)(function (_ref28) {
    var _ref29 = _slicedToArray(_ref28, 1),
      danger = _ref29[0];
    return (0, _manipulation.tint)(danger, 0.9);
  }, ['colors.danger']),
  backgroundBaseSubdued: (0, _utils.computed)(function (_ref30) {
    var _ref31 = _slicedToArray(_ref30, 1),
      body = _ref31[0];
    return body;
  }, ['colors.body']),
  backgroundBaseDisabled: (0, _utils.computed)(function (_ref32) {
    var _ref33 = _slicedToArray(_ref32, 1),
      disabled = _ref33[0];
    return disabled;
  }, ['colors.disabled']),
  backgroundBaseHighlighted: (0, _utils.computed)(function (_ref34) {
    var _ref35 = _slicedToArray(_ref34, 1),
      backgroundBaseSubdued = _ref35[0];
    return backgroundBaseSubdued;
  }, ['colors.backgroundBaseSubdued']),
  backgroundBasePlain: (0, _utils.computed)(function (_ref36) {
    var _ref37 = _slicedToArray(_ref36, 1),
      emptyShade = _ref37[0];
    return emptyShade;
  }, ['colors.emptyShade']),
  backgroundBaseFormsPrepend: (0, _utils.computed)(function (_ref38) {
    var _ref39 = _slicedToArray(_ref38, 1),
      lightShade = _ref39[0];
    return (0, _manipulation.tint)(lightShade, 0.5);
  }, ['colors.lightShade']),
  backgroundBaseFormsControlDisabled: (0, _utils.computed)(function (_ref40) {
    var _ref41 = _slicedToArray(_ref40, 1),
      mediumShade = _ref41[0];
    return mediumShade;
  }, ['colors.mediumShade']),
  backgroundBaseInteractiveHover: (0, _utils.computed)(function (_ref42) {
    var _ref43 = _slicedToArray(_ref42, 1),
      lightShade = _ref43[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundBaseInteractiveSelect: (0, _utils.computed)(function (_ref44) {
    var _ref45 = _slicedToArray(_ref44, 1),
      primary = _ref45[0];
    return (0, _manipulation.tint)(primary, 0.96);
  }, ['colors.primary']),
  backgroundBaseInteractiveOverlay: (0, _utils.computed)(function (_ref46) {
    var _ref47 = _slicedToArray(_ref46, 1),
      ink = _ref47[0];
    return (0, _manipulation.transparentize)(ink, 0.5);
  }, ['colors.ink']),
  backgroundBaseSkeletonEdge: (0, _utils.computed)(function (_ref48) {
    var _ref49 = _slicedToArray(_ref48, 1),
      lightShade = _ref49[0];
    return (0, _manipulation.tint)(lightShade, 0.65);
  }, ['colors.lightShade']),
  backgroundBaseSkeletonMiddle: (0, _utils.computed)(function (_ref50) {
    var _ref51 = _slicedToArray(_ref50, 1),
      lightShade = _ref51[0];
    return (0, _manipulation.tint)(lightShade, 0.8);
  }, ['colors.lightShade']),
  backgroundLightPrimary: (0, _utils.computed)(function (_ref52) {
    var _ref53 = _slicedToArray(_ref52, 1),
      primary = _ref53[0];
    return (0, _manipulation.tint)(primary, 0.8);
  }, ['colors.primary']),
  backgroundLightAccent: (0, _utils.computed)(function (_ref54) {
    var _ref55 = _slicedToArray(_ref54, 1),
      accent = _ref55[0];
    return (0, _manipulation.tint)(accent, 0.8);
  }, ['colors.accent']),
  backgroundLightAccentSecondary: (0, _utils.computed)(function (_ref56) {
    var _ref57 = _slicedToArray(_ref56, 1),
      success = _ref57[0];
    return (0, _manipulation.tint)(success, 0.8);
  }, ['colors.success']),
  backgroundLightSuccess: (0, _utils.computed)(function (_ref58) {
    var _ref59 = _slicedToArray(_ref58, 1),
      success = _ref59[0];
    return (0, _manipulation.tint)(success, 0.8);
  }, ['colors.success']),
  backgroundLightWarning: (0, _utils.computed)(function (_ref60) {
    var _ref61 = _slicedToArray(_ref60, 1),
      warning = _ref61[0];
    return (0, _manipulation.tint)(warning, 0.8);
  }, ['colors.warning']),
  backgroundLightDanger: (0, _utils.computed)(function (_ref62) {
    var _ref63 = _slicedToArray(_ref62, 1),
      danger = _ref63[0];
    return (0, _manipulation.tint)(danger, 0.8);
  }, ['colors.danger']),
  backgroundLightText: (0, _utils.computed)(function (_ref64) {
    var _ref65 = _slicedToArray(_ref64, 1),
      lightShade = _ref65[0];
    return (0, _manipulation.tint)(lightShade, 0.5);
  }, ['colors.lightShade']),
  backgroundFilledPrimary: (0, _utils.computed)(function (_ref66) {
    var _ref67 = _slicedToArray(_ref66, 1),
      primary = _ref67[0];
    return primary;
  }, ['colors.primary']),
  backgroundFilledAccent: (0, _utils.computed)(function (_ref68) {
    var _ref69 = _slicedToArray(_ref68, 1),
      accent = _ref69[0];
    return (0, _manipulation.tint)(accent, 0.3);
  }, ['colors.accent']),
  backgroundFilledAccentSecondary: (0, _utils.computed)(function (_ref70) {
    var _ref71 = _slicedToArray(_ref70, 1),
      success = _ref71[0];
    return (0, _manipulation.tint)(success, 0.3);
  }, ['colors.success']),
  backgroundFilledSuccess: (0, _utils.computed)(function (_ref72) {
    var _ref73 = _slicedToArray(_ref72, 1),
      success = _ref73[0];
    return (0, _manipulation.tint)(success, 0.3);
  }, ['colors.success']),
  backgroundFilledWarning: (0, _utils.computed)(function (_ref74) {
    var _ref75 = _slicedToArray(_ref74, 1),
      warning = _ref75[0];
    return warning;
  }, ['colors.warning']),
  backgroundFilledDanger: (0, _utils.computed)(function (_ref76) {
    var _ref77 = _slicedToArray(_ref76, 1),
      danger = _ref77[0];
    return danger;
  }, ['colors.danger']),
  backgroundFilledText: (0, _utils.computed)(function (_ref78) {
    var _ref79 = _slicedToArray(_ref78, 1),
      darkShade = _ref79[0];
    return darkShade;
  }, ['colors.darkShade'])
};
var transparent_background_colors = exports.transparent_background_colors = {
  backgroundTransparent: 'transparent',
  backgroundTransparentPrimary: (0, _utils.computed)(function (_ref80) {
    var _ref81 = _slicedToArray(_ref80, 1),
      primary = _ref81[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundTransparentAccent: (0, _utils.computed)(function (_ref82) {
    var _ref83 = _slicedToArray(_ref82, 1),
      accent = _ref83[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundTransparentAccentSecondary: (0, _utils.computed)(function (_ref84) {
    var _ref85 = _slicedToArray(_ref84, 1),
      success = _ref85[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundTransparentSuccess: (0, _utils.computed)(function (_ref86) {
    var _ref87 = _slicedToArray(_ref86, 1),
      success = _ref87[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundTransparentWarning: (0, _utils.computed)(function (_ref88) {
    var _ref89 = _slicedToArray(_ref88, 1),
      warning = _ref89[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundTransparentDanger: (0, _utils.computed)(function (_ref90) {
    var _ref91 = _slicedToArray(_ref90, 1),
      danger = _ref91[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundTransparentSubdued: (0, _utils.computed)(function (_ref92) {
    var _ref93 = _slicedToArray(_ref92, 1),
      lightShade = _ref93[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundTransparentHighlighted: (0, _utils.computed)(function (_ref94) {
    var _ref95 = _slicedToArray(_ref94, 1),
      backgroundTransparentSubdued = _ref95[0];
    return backgroundTransparentSubdued;
  }, ['colors.backgroundTransparentSubdued']),
  backgroundTransparentPlain: (0, _utils.computed)(function (_ref96) {
    var _ref97 = _slicedToArray(_ref96, 1),
      ghost = _ref97[0];
    return (0, _manipulation.transparentize)(ghost, 0.2);
  }, ['colors.ghost'])
};
var border_colors = exports.border_colors = {
  borderBasePrimary: (0, _utils.computed)(function (_ref98) {
    var _ref99 = _slicedToArray(_ref98, 1),
      primary = _ref99[0];
    return (0, _manipulation.tint)(primary, 0.6);
  }, ['colors.primary']),
  borderBaseAccent: (0, _utils.computed)(function (_ref100) {
    var _ref101 = _slicedToArray(_ref100, 1),
      accent = _ref101[0];
    return (0, _manipulation.tint)(accent, 0.6);
  }, ['colors.accent']),
  borderBaseAccentSecondary: (0, _utils.computed)(function (_ref102) {
    var _ref103 = _slicedToArray(_ref102, 1),
      success = _ref103[0];
    return (0, _manipulation.tint)(success, 0.6);
  }, ['colors.success']),
  borderBaseSuccess: (0, _utils.computed)(function (_ref104) {
    var _ref105 = _slicedToArray(_ref104, 1),
      success = _ref105[0];
    return (0, _manipulation.tint)(success, 0.6);
  }, ['colors.success']),
  borderBaseWarning: (0, _utils.computed)(function (_ref106) {
    var _ref107 = _slicedToArray(_ref106, 1),
      warning = _ref107[0];
    return (0, _manipulation.tint)(warning, 0.4);
  }, ['colors.warning']),
  borderBaseDanger: (0, _utils.computed)(function (_ref108) {
    var _ref109 = _slicedToArray(_ref108, 1),
      danger = _ref109[0];
    return (0, _manipulation.tint)(danger, 0.6);
  }, ['colors.danger']),
  borderBaseSubdued: (0, _utils.computed)(function (_ref110) {
    var _ref111 = _slicedToArray(_ref110, 1),
      lightShade = _ref111[0];
    return lightShade;
  }, ['colors.lightShade']),
  borderBaseDisabled: (0, _utils.computed)(function (_ref112) {
    var _ref113 = _slicedToArray(_ref112, 1),
      lightShade = _ref113[0];
    return (0, _manipulation.transparentize)((0, _manipulation.darken)(lightShade, 0.4), 0.1);
  }, ['colors.lightShade']),
  borderBasePlain: (0, _utils.computed)(function (_ref114) {
    var _ref115 = _slicedToArray(_ref114, 1),
      lightShade = _ref115[0];
    return lightShade;
  }, ['colors.lightShade']),
  borderBaseFloating: 'transparent',
  borderBaseFormsColorSwatch: (0, _utils.computed)(function (_ref116) {
    var _ref117 = _slicedToArray(_ref116, 1),
      fullShade = _ref117[0];
    return (0, _manipulation.transparentize)(fullShade, 0.1);
  }, ['colors.fullShade']),
  borderBaseFormsControl: (0, _utils.computed)(function (_ref118) {
    var _ref119 = _slicedToArray(_ref118, 1),
      lightestShade = _ref119[0];
    return (0, _manipulation.shade)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  borderStrongPrimary: (0, _utils.computed)(function (_ref120) {
    var _ref121 = _slicedToArray(_ref120, 1),
      borderBasePrimary = _ref121[0];
    return borderBasePrimary;
  }, ['colors.borderBasePrimary']),
  borderStrongAccent: (0, _utils.computed)(function (_ref122) {
    var _ref123 = _slicedToArray(_ref122, 1),
      borderBaseAccent = _ref123[0];
    return borderBaseAccent;
  }, ['colors.borderBaseAccent']),
  borderStrongAccentSecondary: (0, _utils.computed)(function (_ref124) {
    var _ref125 = _slicedToArray(_ref124, 1),
      borderBaseAccentSecondary = _ref125[0];
    return borderBaseAccentSecondary;
  }, ['colors.borderBaseAccentSecondary']),
  borderStrongSuccess: (0, _utils.computed)(function (_ref126) {
    var _ref127 = _slicedToArray(_ref126, 1),
      borderBaseSuccess = _ref127[0];
    return borderBaseSuccess;
  }, ['colors.borderBaseSuccess']),
  borderStrongWarning: (0, _utils.computed)(function (_ref128) {
    var _ref129 = _slicedToArray(_ref128, 1),
      borderBaseWarning = _ref129[0];
    return borderBaseWarning;
  }, ['colors.borderBaseWarning']),
  borderStrongDanger: (0, _utils.computed)(function (_ref130) {
    var _ref131 = _slicedToArray(_ref130, 1),
      borderBaseDanger = _ref131[0];
    return borderBaseDanger;
  }, ['colors.borderBaseDanger'])
};
var light_colors = exports.light_colors = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, brand_colors), shade_colors), special_colors), brand_text_colors), text_colors), background_colors), transparent_background_colors), border_colors);

/*
 * DARK THEME
 */

var dark_shades = exports.dark_shades = {
  emptyShade: '#1D1E24',
  lightestShade: '#25262E',
  lightShade: '#343741',
  mediumShade: '#535966',
  darkShade: '#98A2B3',
  darkestShade: '#D4DAE5',
  fullShade: '#FFFFFF'
};
var dark_background_colors = exports.dark_background_colors = {
  backgroundBasePrimary: (0, _utils.computed)(function (_ref132) {
    var _ref133 = _slicedToArray(_ref132, 1),
      primary = _ref133[0];
    return (0, _manipulation.shade)(primary, 0.8);
  }, ['colors.primary']),
  backgroundBaseAccent: (0, _utils.computed)(function (_ref134) {
    var _ref135 = _slicedToArray(_ref134, 1),
      accent = _ref135[0];
    return (0, _manipulation.shade)(accent, 0.8);
  }, ['colors.accent']),
  backgroundBaseAccentSecondary: (0, _utils.computed)(function (_ref136) {
    var _ref137 = _slicedToArray(_ref136, 1),
      success = _ref137[0];
    return (0, _manipulation.shade)(success, 0.8);
  }, ['colors.success']),
  backgroundBaseSuccess: (0, _utils.computed)(function (_ref138) {
    var _ref139 = _slicedToArray(_ref138, 1),
      success = _ref139[0];
    return (0, _manipulation.shade)(success, 0.8);
  }, ['colors.success']),
  backgroundBaseWarning: (0, _utils.computed)(function (_ref140) {
    var _ref141 = _slicedToArray(_ref140, 1),
      warning = _ref141[0];
    return (0, _manipulation.shade)(warning, 0.8);
  }, ['colors.warning']),
  backgroundBaseDanger: (0, _utils.computed)(function (_ref142) {
    var _ref143 = _slicedToArray(_ref142, 1),
      danger = _ref143[0];
    return (0, _manipulation.shade)(danger, 0.8);
  }, ['colors.danger']),
  backgroundBaseSubdued: (0, _utils.computed)(function (_ref144) {
    var _ref145 = _slicedToArray(_ref144, 1),
      body = _ref145[0];
    return body;
  }, ['colors.body']),
  backgroundBaseDisabled: (0, _utils.computed)(function (_ref146) {
    var _ref147 = _slicedToArray(_ref146, 1),
      disabled = _ref147[0];
    return disabled;
  }, ['colors.disabled']),
  backgroundBaseHighlighted: (0, _utils.computed)(function (_ref148) {
    var _ref149 = _slicedToArray(_ref148, 1),
      backgroundBaseSubdued = _ref149[0];
    return backgroundBaseSubdued;
  }, ['colors.backgroundBaseSubdued']),
  backgroundBasePlain: (0, _utils.computed)(function (_ref150) {
    var _ref151 = _slicedToArray(_ref150, 1),
      emptyShade = _ref151[0];
    return emptyShade;
  }, ['colors.emptyShade']),
  backgroundBaseFormsPrepend: (0, _utils.computed)(function (_ref152) {
    var _ref153 = _slicedToArray(_ref152, 1),
      lightShade = _ref153[0];
    return (0, _manipulation.shade)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundBaseFormsControlDisabled: (0, _utils.computed)(function (_ref154) {
    var _ref155 = _slicedToArray(_ref154, 1),
      mediumShade = _ref155[0];
    return mediumShade;
  }, ['colors.mediumShade']),
  backgroundBaseInteractiveHover: (0, _utils.computed)(function (_ref156) {
    var _ref157 = _slicedToArray(_ref156, 1),
      lightShade = _ref157[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundBaseInteractiveSelect: (0, _utils.computed)(function (_ref158) {
    var _ref159 = _slicedToArray(_ref158, 1),
      primary = _ref159[0];
    return (0, _manipulation.shade)(primary, 0.7);
  }, ['colors.primary']),
  backgroundBaseInteractiveOverlay: (0, _utils.computed)(function (_ref160) {
    var _ref161 = _slicedToArray(_ref160, 1),
      ink = _ref161[0];
    return (0, _manipulation.transparentize)(ink, 0.5);
  }, ['colors.ink']),
  backgroundBaseSkeletonEdge: (0, _utils.computed)(function (_ref162) {
    var _ref163 = _slicedToArray(_ref162, 1),
      lightShade = _ref163[0];
    return (0, _manipulation.shade)(lightShade, 0.12);
  }, ['colors.lightShade']),
  backgroundBaseSkeletonMiddle: (0, _utils.computed)(function (_ref164) {
    var _ref165 = _slicedToArray(_ref164, 1),
      lightShade = _ref165[0];
    return (0, _manipulation.shade)(lightShade, 0.24);
  }, ['colors.lightShade']),
  backgroundLightPrimary: (0, _utils.computed)(function (_ref166) {
    var _ref167 = _slicedToArray(_ref166, 1),
      primary = _ref167[0];
    return (0, _manipulation.shade)(primary, 0.7);
  }, ['colors.primary']),
  backgroundLightAccent: (0, _utils.computed)(function (_ref168) {
    var _ref169 = _slicedToArray(_ref168, 1),
      accent = _ref169[0];
    return (0, _manipulation.shade)(accent, 0.7);
  }, ['colors.accent']),
  backgroundLightAccentSecondary: (0, _utils.computed)(function (_ref170) {
    var _ref171 = _slicedToArray(_ref170, 1),
      success = _ref171[0];
    return (0, _manipulation.shade)(success, 0.7);
  }, ['colors.success']),
  backgroundLightSuccess: (0, _utils.computed)(function (_ref172) {
    var _ref173 = _slicedToArray(_ref172, 1),
      success = _ref173[0];
    return (0, _manipulation.shade)(success, 0.7);
  }, ['colors.success']),
  backgroundLightWarning: (0, _utils.computed)(function (_ref174) {
    var _ref175 = _slicedToArray(_ref174, 1),
      warning = _ref175[0];
    return (0, _manipulation.shade)(warning, 0.7);
  }, ['colors.warning']),
  backgroundLightDanger: (0, _utils.computed)(function (_ref176) {
    var _ref177 = _slicedToArray(_ref176, 1),
      danger = _ref177[0];
    return (0, _manipulation.shade)(danger, 0.7);
  }, ['colors.danger']),
  backgroundLightText: (0, _utils.computed)(function (_ref178) {
    var _ref179 = _slicedToArray(_ref178, 1),
      lightShade = _ref179[0];
    return (0, _manipulation.shade)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundFilledPrimary: (0, _utils.computed)(function (_ref180) {
    var _ref181 = _slicedToArray(_ref180, 1),
      primary = _ref181[0];
    return primary;
  }, ['colors.primary']),
  backgroundFilledAccent: (0, _utils.computed)(function (_ref182) {
    var _ref183 = _slicedToArray(_ref182, 1),
      accent = _ref183[0];
    return accent;
  }, ['colors.accent']),
  backgroundFilledAccentSecondary: (0, _utils.computed)(function (_ref184) {
    var _ref185 = _slicedToArray(_ref184, 1),
      success = _ref185[0];
    return success;
  }, ['colors.success']),
  backgroundFilledSuccess: (0, _utils.computed)(function (_ref186) {
    var _ref187 = _slicedToArray(_ref186, 1),
      success = _ref187[0];
    return success;
  }, ['colors.success']),
  backgroundFilledWarning: (0, _utils.computed)(function (_ref188) {
    var _ref189 = _slicedToArray(_ref188, 1),
      warning = _ref189[0];
    return warning;
  }, ['colors.warning']),
  backgroundFilledDanger: (0, _utils.computed)(function (_ref190) {
    var _ref191 = _slicedToArray(_ref190, 1),
      danger = _ref191[0];
    return danger;
  }, ['colors.danger']),
  backgroundFilledText: (0, _utils.computed)(function (_ref192) {
    var _ref193 = _slicedToArray(_ref192, 1),
      text = _ref193[0];
    return text;
  }, ['colors.text'])
};
var dark_transparent_background_colors = exports.dark_transparent_background_colors = _objectSpread(_objectSpread({}, transparent_background_colors), {}, {
  backgroundTransparentSubdued: (0, _utils.computed)(function (_ref194) {
    var _ref195 = _slicedToArray(_ref194, 1),
      lightShade = _ref195[0];
    return (0, _manipulation.transparentize)(lightShade, 0.4);
  }, ['colors.lightShade']),
  backgroundTransparentHighlighted: (0, _utils.computed)(function (_ref196) {
    var _ref197 = _slicedToArray(_ref196, 1),
      backgroundTransparentSubdued = _ref197[0];
    return backgroundTransparentSubdued;
  }, ['colors.backgroundTransparentSubdued'])
});
var dark_border_colors = exports.dark_border_colors = {
  borderBasePrimary: (0, _utils.computed)(function (_ref198) {
    var _ref199 = _slicedToArray(_ref198, 1),
      primary = _ref199[0];
    return (0, _manipulation.shade)(primary, 0.6);
  }, ['colors.primary']),
  borderBaseAccent: (0, _utils.computed)(function (_ref200) {
    var _ref201 = _slicedToArray(_ref200, 1),
      accent = _ref201[0];
    return (0, _manipulation.shade)(accent, 0.6);
  }, ['colors.accent']),
  borderBaseAccentSecondary: (0, _utils.computed)(function (_ref202) {
    var _ref203 = _slicedToArray(_ref202, 1),
      success = _ref203[0];
    return (0, _manipulation.shade)(success, 0.6);
  }, ['colors.success']),
  borderBaseSuccess: (0, _utils.computed)(function (_ref204) {
    var _ref205 = _slicedToArray(_ref204, 1),
      success = _ref205[0];
    return (0, _manipulation.shade)(success, 0.6);
  }, ['colors.success']),
  borderBaseWarning: (0, _utils.computed)(function (_ref206) {
    var _ref207 = _slicedToArray(_ref206, 1),
      warning = _ref207[0];
    return (0, _manipulation.shade)(warning, 0.4);
  }, ['colors.warning']),
  borderBaseDanger: (0, _utils.computed)(function (_ref208) {
    var _ref209 = _slicedToArray(_ref208, 1),
      danger = _ref209[0];
    return (0, _manipulation.shade)(danger, 0.6);
  }, ['colors.danger']),
  borderBaseSubdued: (0, _utils.computed)(function (_ref210) {
    var _ref211 = _slicedToArray(_ref210, 1),
      lightShade = _ref211[0];
    return lightShade;
  }, ['colors.lightShade']),
  borderBaseDisabled: (0, _utils.computed)(function (_ref212) {
    var _ref213 = _slicedToArray(_ref212, 1),
      ghost = _ref213[0];
    return (0, _manipulation.transparentize)(ghost, 0.1);
  }, ['colors.ghost']),
  borderBasePlain: (0, _utils.computed)(function (_ref214) {
    var _ref215 = _slicedToArray(_ref214, 1),
      lightShade = _ref215[0];
    return lightShade;
  }, ['colors.lightShade']),
  borderBaseFloating: 'transparent',
  borderBaseFormsColorSwatch: (0, _utils.computed)(function (_ref216) {
    var _ref217 = _slicedToArray(_ref216, 1),
      fullShade = _ref217[0];
    return (0, _manipulation.transparentize)(fullShade, 0.1);
  }, ['colors.fullShade']),
  borderBaseFormsControl: (0, _utils.computed)(function (_ref218) {
    var _ref219 = _slicedToArray(_ref218, 1),
      lightestShade = _ref219[0];
    return (0, _manipulation.tint)(lightestShade, 0.31);
  }, ['colors.lightestShade']),
  borderStrongPrimary: (0, _utils.computed)(function (_ref220) {
    var _ref221 = _slicedToArray(_ref220, 1),
      borderBasePrimary = _ref221[0];
    return borderBasePrimary;
  }, ['colors.borderBasePrimary']),
  borderStrongAccent: (0, _utils.computed)(function (_ref222) {
    var _ref223 = _slicedToArray(_ref222, 1),
      borderBaseAccent = _ref223[0];
    return borderBaseAccent;
  }, ['colors.borderBaseAccent']),
  borderStrongAccentSecondary: (0, _utils.computed)(function (_ref224) {
    var _ref225 = _slicedToArray(_ref224, 1),
      borderBaseAccentSecondary = _ref225[0];
    return borderBaseAccentSecondary;
  }, ['colors.borderBaseAccentSecondary']),
  borderStrongSuccess: (0, _utils.computed)(function (_ref226) {
    var _ref227 = _slicedToArray(_ref226, 1),
      borderBaseSuccess = _ref227[0];
    return borderBaseSuccess;
  }, ['colors.borderBaseSuccess']),
  borderStrongWarning: (0, _utils.computed)(function (_ref228) {
    var _ref229 = _slicedToArray(_ref228, 1),
      borderBaseWarning = _ref229[0];
    return borderBaseWarning;
  }, ['colors.borderBaseWarning']),
  borderStrongDanger: (0, _utils.computed)(function (_ref230) {
    var _ref231 = _slicedToArray(_ref230, 1),
      borderBaseDanger = _ref231[0];
    return borderBaseDanger;
  }, ['colors.borderBaseDanger'])
};
var dark_colors_ams = exports.dark_colors_ams = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({
  // Brand
  primary: '#36A2EF',
  accent: '#F68FBE',
  accentSecondary: '#7DDED8',
  success: '#7DDED8',
  warning: '#F3D371',
  danger: '#F86B63'
}, dark_shades), {}, {
  // Special
  body: (0, _utils.computed)(function (_ref232) {
    var _ref233 = _slicedToArray(_ref232, 1),
      lightestShade = _ref233[0];
    return (0, _manipulation.shade)(lightestShade, 0.45);
  }, ['colors.lightestShade']),
  highlight: '#2E2D25',
  disabled: '#515761',
  disabledText: (0, _utils.computed)((0, _contrast.makeDisabledContrastColor)('colors.disabled')),
  shadow: (0, _utils.computed)(function (_ref234) {
    var colors = _ref234.colors;
    return colors.ink;
  })
}, brand_text_colors), {}, {
  // Text
  text: '#DFE5EF',
  title: (0, _utils.computed)(function (_ref235) {
    var _ref236 = _slicedToArray(_ref235, 1),
      text = _ref236[0];
    return text;
  }, ['colors.text']),
  subduedText: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.mediumShade')),
  link: (0, _utils.computed)(function (_ref237) {
    var _ref238 = _slicedToArray(_ref237, 1),
      primaryText = _ref238[0];
    return primaryText;
  }, ['colors.primaryText']),
  textParagraph: '#DFE5EF',
  textHeading: (0, _utils.computed)(function (_ref239) {
    var _ref240 = _slicedToArray(_ref239, 1),
      text = _ref240[0];
    return text;
  }, ['colors.text']),
  textSubdued: (0, _utils.computed)((0, _contrast.makeHighContrastColor)('colors.mediumShade')),
  textDisabled: (0, _utils.computed)((0, _contrast.makeDisabledContrastColor)('colors.disabled')),
  textInverse: (0, _utils.computed)(function (_ref241) {
    var _ref242 = _slicedToArray(_ref241, 1),
      ink = _ref242[0];
    return ink;
  }, ['colors.ink'])
}, dark_background_colors), dark_transparent_background_colors), dark_border_colors);

/*
 * FULL
 */

var colors = exports.colors = {
  ghost: '#FFFFFF',
  ink: '#000000',
  plainLight: '#FFFFFF',
  plainDark: '#000000',
  LIGHT: light_colors,
  DARK: dark_colors_ams,
  vis: _colors_vis.colorVis
};