"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPaletteWarm = exports.euiPaletteRed = exports.euiPaletteGreen = exports.euiPaletteGray = exports.euiPaletteForTemperature = exports.euiPaletteForStatus = exports.euiPaletteForLightBackground = exports.euiPaletteForDarkBackground = exports.euiPaletteCool = exports.euiPaletteComplementary = exports.euiPaletteColorBlindBehindText = exports.euiPaletteColorBlind = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _color_palette = require("./color_palette");
var _vis_color_store = require("./vis_color_store");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var flatten = function flatten(arr) {
  var _ref;
  return (_ref = []).concat.apply(_ref, _toConsumableArray(arr));
};
var euiPalette = function euiPalette(colors, steps) {
  var diverge = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var categorical = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  // This function also trims the first color so white/black is never a color
  if (!diverge && steps > 1) {
    var palette = (0, _color_palette.colorPalette)(colors, steps + 1);
    palette.shift();
    return palette;
  }
  return (0, _color_palette.colorPalette)(colors, steps, diverge, categorical);
};
/**
 * NOTE: These functions rely on base vis colors of the theme which are provided via a global
 * singleton instance `EUI_VIS_COLOR_STORE` that's updated by the EuiProvider on theme change.
 * Make sure the function is recalled on theme change to retrieve theme-related colors.
 *
 * Outside of a react component you can use the `subscibe()` method on the `EUI_VIS_COLOR_STORE`
 * to subscribe to updates and update your usages to ensure latest colors are loaded.
 */
var euiPaletteColorBlind = exports.euiPaletteColorBlind = function euiPaletteColorBlind() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref2$rotations = _ref2.rotations,
    rotations = _ref2$rotations === void 0 ? 1 : _ref2$rotations,
    _ref2$order = _ref2.order,
    order = _ref2$order === void 0 ? 'append' : _ref2$order,
    _ref2$direction = _ref2.direction,
    direction = _ref2$direction === void 0 ? 'lighter' : _ref2$direction,
    _ref2$sortBy = _ref2.sortBy,
    sortBy = _ref2$sortBy === void 0 ? 'default' : _ref2$sortBy,
    _ref2$sortShift = _ref2.sortShift,
    sortShift = _ref2$sortShift === void 0 ? '-100' : _ref2$sortShift,
    colors = _ref2.colors;
  var _colors = [];
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var base = [visColors.euiColorVis0, visColors.euiColorVis1, visColors.euiColorVis2, visColors.euiColorVis3, visColors.euiColorVis4, visColors.euiColorVis5, visColors.euiColorVis6, visColors.euiColorVis7, visColors.euiColorVis8, visColors.euiColorVis9];
  if (sortBy === 'natural') {
    // Sort the colors based on the color wheel, but shifting the values based on sortShift
    base = _toConsumableArray(base).sort(function (a, b) {
      return (0, _chromaJs.default)(a).set('hsl.h', sortShift).hsl()[0] - (0, _chromaJs.default)(b).set('hsl.h', sortShift).hsl()[0];
    });
  }
  if (rotations > 1) {
    var palettes = base.map(function (color) {
      // Create the darkest and lightest versions of each color using black and white
      var palette = (0, _color_palette.colorPalette)(['black', color, 'white'], 5, false, true);
      // Then removing the extremes
      palette.pop();
      palette.shift();
      switch (direction) {
        case 'lighter':
          return (0, _color_palette.colorPalette)([palette[1], palette[2]], rotations, false, true);
        case 'darker':
          return (0, _color_palette.colorPalette)([palette[1], palette[0]], rotations, false, true);
        case 'both':
          return (0, _color_palette.colorPalette)(palette, rotations, false, true);
      }
    });
    if (order === 'group') {
      _colors = flatten(palettes);
    } else {
      var _loop = function _loop(i) {
        var _colors2;
        var rotation = palettes.map(function (palette) {
          return palette[i];
        });
        (_colors2 = _colors).push.apply(_colors2, _toConsumableArray(rotation));
      };
      for (var i = 0; i < rotations; i++) {
        _loop(i);
      }
    }
  } else {
    _colors = base;
  }
  return _colors;
};

/**
 * Color blind palette with text is meant for use when text is applied on top of the color.
 * It increases the brightness of the color to give the text more contrast.
 *
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteColorBlindBehindText = exports.euiPaletteColorBlindBehindText = function euiPaletteColorBlindBehindText() {
  var paletteProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var hasVisColorAdjustment = paletteProps.hasVisColorAdjustment;
  var _hasVisColorAdjustment = hasVisColorAdjustment !== null && hasVisColorAdjustment !== void 0 ? hasVisColorAdjustment : _vis_color_store.EUI_VIS_COLOR_STORE.hasVisColorAdjustment;
  var originalPalette = euiPaletteColorBlind(paletteProps);

  // new theme palette has required contrast, we don't need to adjust them
  if (!_hasVisColorAdjustment) return originalPalette;
  var newPalette = originalPalette.map(function (color) {
    return (0, _chromaJs.default)(color).brighten(0.5).hex();
  });
  return newPalette;
};
var _getVisColorsAsText = function _getVisColorsAsText(visColors, keys) {
  return keys.reduce(function (colors, curr) {
    return [].concat(_toConsumableArray(colors), [visColors[curr]]);
  }, []);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteForLightBackground = exports.euiPaletteForLightBackground = function euiPaletteForLightBackground() {
  var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    colors = _ref3.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var visColorsAsTextKeys = Object.keys(visColors).filter(function (color) {
    return color.includes('AsTextLight');
  });
  return _getVisColorsAsText(visColors, visColorsAsTextKeys);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteForDarkBackground = exports.euiPaletteForDarkBackground = function euiPaletteForDarkBackground() {
  var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    colors = _ref4.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var visColorsAsTextKeys = Object.keys(visColors).filter(function (color) {
    return color.includes('AsTextDark');
  });
  return _getVisColorsAsText(visColors, visColorsAsTextKeys);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteForStatus = exports.euiPaletteForStatus = function euiPaletteForStatus(steps) {
  var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref5.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  if (steps === 1) {
    return [visColors.euiColorVisSuccess0];
  }
  if (steps <= 3) {
    return euiPalette([visColors.euiColorVisSuccess0, visColors.euiColorVisWarning0, visColors.euiColorVisDanger0], steps, true);
  }
  return euiPalette([visColors.euiColorVisSuccess0, visColors.euiColorVisSuccess1, visColors.euiColorVisWarning0, visColors.euiColorVisDanger1, visColors.euiColorVisDanger0], steps, true);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteForTemperature = exports.euiPaletteForTemperature = function euiPaletteForTemperature(steps) {
  var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref6.colors,
    hasVisColorAdjustment = _ref6.hasVisColorAdjustment;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var _hasVisColorAdjustment = hasVisColorAdjustment !== null && hasVisColorAdjustment !== void 0 ? hasVisColorAdjustment : _vis_color_store.EUI_VIS_COLOR_STORE.hasVisColorAdjustment;
  if (steps === 1) {
    return [visColors.euiColorVisCool2];
  } else if (steps <= 3) {
    return euiPalette([visColors.euiColorVisCool2, visColors.euiColorVisWarm2], steps, true);
  }
  var cools = (0, _color_palette.colorPalette)([visColors.euiColorVisCool2, visColors.euiColorVisCool1, visColors.euiColorVisCool0], 3);
  var warms = (0, _color_palette.colorPalette)([visColors.euiColorVisWarm0, visColors.euiColorVisWarm1, visColors.euiColorVisWarm2], 3);
  var paletteColors = _hasVisColorAdjustment ? [].concat(_toConsumableArray(cools), _toConsumableArray(warms)) : [].concat(_toConsumableArray(cools), [visColors.euiColorVisNeutral0], _toConsumableArray(warms));
  return euiPalette(paletteColors, steps, true);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteComplementary = exports.euiPaletteComplementary = function euiPaletteComplementary(steps) {
  var _ref7 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref7.colors,
    hasVisColorAdjustment = _ref7.hasVisColorAdjustment;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var _hasVisColorAdjustment = hasVisColorAdjustment !== null && hasVisColorAdjustment !== void 0 ? hasVisColorAdjustment : _vis_color_store.EUI_VIS_COLOR_STORE.hasVisColorAdjustment;
  if (steps === 1) {
    return [visColors.euiColorVisComplementary0];
  }
  var paletteColors = _hasVisColorAdjustment ? [visColors.euiColorVisComplementary0, visColors.euiColorVisComplementary1] : [visColors.euiColorVisComplementary0, visColors.euiColorVisNeutral0, visColors.euiColorVisComplementary1];
  return euiPalette(paletteColors, steps, true);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteRed = exports.euiPaletteRed = function euiPaletteRed(steps) {
  var _ref8 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref8.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  if (steps === 1) {
    return [visColors.euiColorVisDanger1];
  }
  return euiPalette([visColors.euiColorVisNeutral0, visColors.euiColorVisDanger0], steps);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteGreen = exports.euiPaletteGreen = function euiPaletteGreen(steps) {
  var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref9.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  if (steps === 1) {
    return [visColors.euiColorVisSuccess1];
  }
  return euiPalette([visColors.euiColorVisNeutral0, visColors.euiColorVisSuccess0], steps);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteCool = exports.euiPaletteCool = function euiPaletteCool(steps) {
  var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref10.colors,
    hasVisColorAdjustment = _ref10.hasVisColorAdjustment;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  var _hasVisColorAdjustment = hasVisColorAdjustment !== null && hasVisColorAdjustment !== void 0 ? hasVisColorAdjustment : _vis_color_store.EUI_VIS_COLOR_STORE.hasVisColorAdjustment;
  if (steps === 1) {
    return [visColors.euiColorVisCool1];
  }
  return euiPalette([_hasVisColorAdjustment ? visColors.euiColorVisNeutral0 : visColors.euiColorVisCool0, visColors.euiColorVisCool1, visColors.euiColorVisCool2], steps);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteWarm = exports.euiPaletteWarm = function euiPaletteWarm(steps) {
  var _ref11 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref11.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  if (steps === 1) {
    return [visColors.euiColorVisWarm2];
  }
  return euiPalette([visColors.euiColorVisWarm0, visColors.euiColorVisWarm1, visColors.euiColorVisWarm2], steps);
};

/**
 * NOTE: This function is not pure. It relies on `EUI_VIS_COLOR_STORE` which is updated by the
 * EuiProvider on theme change. Ensure to recall the function on theme change or subscribe to the store.
 */
var euiPaletteGray = exports.euiPaletteGray = function euiPaletteGray(steps) {
  var _ref12 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    colors = _ref12.colors;
  var visColors = colors !== null && colors !== void 0 ? colors : _vis_color_store.EUI_VIS_COLOR_STORE.visColors;
  if (steps === 1) {
    return [visColors.euiColorVisGrey1];
  }
  return euiPalette([visColors.euiColorVisNeutral0, visColors.euiColorVisGrey0, visColors.euiColorVisGrey1, visColors.euiColorVisGrey2, visColors.euiColorVisGrey3], steps, false);
};