"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTabsStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiTabsStyles = exports.euiTabsStyles = function euiTabsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiTabs: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-x', 'auto'), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'hidden'), " position:relative;flex-shrink:0;;label:euiTabs;"),
    bottomBorder: /*#__PURE__*/(0, _react.css)((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "box-shadow: inset 0 -".concat(euiTheme.border.width.thin, " 0 ").concat(euiTheme.border.color, ";"),
      forced: (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin)
    }), ";;label:bottomBorder;"),
    // sizes
    s: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.m, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.xl, ";;label:xl;")
  };
};