"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenuItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _beta_badge = require("../badge/beta_badge");
var _form = require("../form");
var _href_validator = require("../../services/security/href_validator");
var _tool_tip = require("../tool_tip");
var _key_pad_menu_item = require("./key_pad_menu_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "isSelected", "isDisabled", "label", "children", "className", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeIconType", "betaBadgeTooltipProps", "href", "rel", "target", "buttonRef", "checkable", "name", "value", "disabled", "onChange"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiKeyPadMenuItem = exports.EuiKeyPadMenuItem = function EuiKeyPadMenuItem(_ref) {
  var id = _ref.id,
    isSelected = _ref.isSelected,
    _isDisabled = _ref.isDisabled,
    label = _ref.label,
    children = _ref.children,
    className = _ref.className,
    betaBadgeLabel = _ref.betaBadgeLabel,
    betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
    betaBadgeIconType = _ref.betaBadgeIconType,
    betaBadgeTooltipProps = _ref.betaBadgeTooltipProps,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    buttonRef = _ref.buttonRef,
    checkable = _ref.checkable,
    name = _ref.name,
    value = _ref.value,
    disabled = _ref.disabled,
    _onChange = _ref.onChange,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = disabled || _isDisabled || !isHrefValid;
  var styles = (0, _services.useEuiMemoizedStyles)(_key_pad_menu_item.euiKeyPadMenuItemStyles);
  var cssStyles = [styles.euiKeyPadMenuItem, !isDisabled ? styles.enabled : styles.disabled.disabled, isSelected && (!isDisabled ? styles.selected : styles.disabled.selected)];
  var classes = (0, _classnames.default)('euiKeyPadMenuItem', className);
  var Element = href && !isDisabled ? 'a' : 'button';
  if (checkable) Element = 'label';
  var itemId = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });
  var childStyles = (0, _services.useEuiMemoizedStyles)(_key_pad_menu_item.euiKeyPadMenuItemChildStyles);
  var checkableElement = (0, _react.useMemo)(function () {
    if (!checkable) return;
    var cssStyles = [childStyles.euiKeyPadMenuItem__checkableInput, !isSelected && isDisabled && childStyles.hideCheckableInput, !isSelected && !isDisabled && childStyles.showCheckableInputOnInteraction];
    var sharedProps = {
      id: itemId,
      className: 'euiKeyPadMenuItem__checkableInput',
      css: cssStyles,
      checked: isSelected,
      disabled: isDisabled,
      name: name
    };
    if (checkable === 'single') {
      return (0, _react2.jsx)(_form.EuiRadio, _extends({}, sharedProps, {
        value: value,
        onChange: function onChange() {
          return _onChange(itemId, value);
        }
      }));
    } else {
      return (0, _react2.jsx)(_form.EuiCheckbox, _extends({}, sharedProps, {
        onChange: function onChange() {
          return _onChange(itemId);
        }
      }));
    }
  }, [checkable, isDisabled, isSelected, _onChange, value, name, itemId, childStyles]);
  var betaBadge = (0, _react.useMemo)(function () {
    if (!betaBadgeLabel) return;
    return (0, _react2.jsx)(_beta_badge.EuiBetaBadge
    // Since we move the tooltip contents to a wrapping EuiToolTip,
    // this badge is purely visual therefore we can safely hide it from screen readers
    , {
      "aria-hidden": "true",
      size: "s",
      color: "subdued",
      className: "euiKeyPadMenuItem__betaBadge",
      css: childStyles.euiKeyPadMenuItem__betaBadge,
      label: betaBadgeLabel.charAt(0),
      iconType: betaBadgeIconType
    });
  }, [betaBadgeLabel, betaBadgeIconType, childStyles]);
  var relObj = {};
  if (href && !isDisabled) {
    relObj.href = href;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
    relObj['aria-current'] = isSelected ? isSelected : undefined;
  } else if (checkable) {
    relObj.htmlFor = itemId;
  } else {
    relObj.disabled = isDisabled;
    relObj.type = 'button';
    relObj['aria-pressed'] = isSelected;
  }
  var button = (0, _react2.jsx)(Element, _extends({
    className: classes,
    css: cssStyles
  }, relObj, rest, {
    // Unable to get past `LegacyRef` conflicts
    ref: buttonRef
  }), (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__inner",
    css: childStyles.euiKeyPadMenuItem__inner
  }, checkable ? checkableElement : betaBadge, (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__icon",
    css: childStyles.euiKeyPadMenuItem__icon
  }, children), (0, _react2.jsx)("span", {
    className: "euiKeyPadMenuItem__label",
    css: childStyles.euiKeyPadMenuItem__label
  }, label)));
  return betaBadgeLabel ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({}, betaBadgeTooltipProps, {
    title: betaBadgeLabel,
    content: betaBadgeTooltipContent,
    delay: "long"
  }), button) : button;
};
EuiKeyPadMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * One will be generated if not provided
     */
  /**
     * One will be generated if not provided
     */
  /**
     * One will be generated if not provided
     */
  id: _propTypes.default.string,
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  children: _propTypes.default.node.isRequired,
  isDisabled: _propTypes.default.bool,
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  isSelected: _propTypes.default.bool,
  /**
     * The text to display beneath the icon
     */
  /**
     * The text to display beneath the icon
     */
  /**
     * The text to display beneath the icon
     */
  label: _propTypes.default.node.isRequired,
  /**
     * Beta badges are unavailable if the item is checkable
     */
  /**
     * Beta badges are unavailable if the item is checkable
     */
  /**
         * Type `'multi'` renders the item as a `<label>` and
         * adds a checkbox.
         */
  /**
         * Type `'single'` renders the item as a `<label>` and
         * adds a radio element.
         */
  checkable: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["single"]).isRequired, _propTypes.default.oneOf(["multi"]).isRequired]).isRequired, _propTypes.default.oneOf([undefined])]),
  /**
         * The `name` attribute for radio inputs;
         * Required in order to group properly
         */
  name: _propTypes.default.string,
  /**
         * The value of the radio input for 'single'
         */
  value: _propTypes.default.string,
  /**
         * Multi: Returns the `id` of the clicked option
         */
  /**
         * Single: Returns the `id` of the clicked option and the `value`
         */
  onChange: _propTypes.default.func,
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,
  rel: _propTypes.default.string,
  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: _propTypes.default.string,
  /**
     * Supply an icon type if the badge should just be an icon
     */
  betaBadgeIconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: _propTypes.default.node,
  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */
  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */
  betaBadgeTooltipProps: _propTypes.default.any
};