"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDualRangeClass = exports.EuiDualRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _number = require("../../../services/number");
var _global_styling = require("../../../global_styling");
var _popover = require("../../popover");
var _form_control_layout = require("../form_control_layout");
var _eui_form_context = require("../eui_form_context");
var _range_draggable = require("./range_draggable");
var _range_highlight = require("./range_highlight");
var _range_input = require("./range_input");
var _range_label = require("./range_label");
var _range_levels_colors = require("./range_levels_colors");
var _range_slider = require("./range_slider");
var _range_thumb = require("./range_thumb");
var _range_track = require("./range_track");
var _range_wrapper = require("./range_wrapper");
var _utils = require("./utils");
var _range = require("./range.styles");
var _dual_range = require("./dual_range.styles");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["className", "css", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "showTicks", "tickInterval", "ticks", "levels", "onBlur", "onChange", "onFocus", "showRange", "value", "isInvalid", "append", "prepend", "minInputProps", "maxInputProps", "inputPopoverProps", "isDraggable", "theme"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiDualRangeClass = exports.EuiDualRangeClass = /*#__PURE__*/function (_Component) {
  function EuiDualRangeClass() {
    var _this;
    _classCallCheck(this, EuiDualRangeClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDualRangeClass, [].concat(args));
    _defineProperty(_this, "state", {
      id: _this.props.id || (0, _services.htmlIdGenerator)()(),
      isPopoverOpen: false,
      rangeWidth: 0
    });
    _defineProperty(_this, "preventPopoverClose", false);
    _defineProperty(_this, "leftPosition", 0);
    _defineProperty(_this, "dragAcc", 0);
    _defineProperty(_this, "_determineInvalidThumbMovement", function (newVal, lower, upper, e) {
      // If the values are invalid, find whether the new value is in the upper
      // or lower half and move the appropriate handle to the new value,
      // while the other handle gets moved to the opposite bound (if invalid)
      var min = _this.props.min;
      var max = _this.props.max;
      var lowerHalf = Math.abs(max - min) / 2 + min;
      var newValIsLow = (0, _number.isWithinRange)(min, lowerHalf, newVal);
      if (newValIsLow) {
        lower = newVal;
        upper = !_this.upperValueIsValid ? max : upper;
      } else {
        lower = !_this.lowerValueIsValid ? min : lower;
        upper = newVal;
      }
      _this._handleOnChange(lower, upper, e);
    });
    _defineProperty(_this, "_determineValidThumbMovement", function (newVal, lower, upper, e) {
      // Lower thumb targeted or right-moving swap has occurred
      if (Math.abs(lower - newVal) < Math.abs(upper - newVal)) {
        lower = newVal;
      }
      // Upper thumb targeted or left-moving swap has occurred
      else {
        upper = newVal;
      }
      _this._handleOnChange(lower, upper, e);
    });
    _defineProperty(_this, "_determineThumbMovement", function (newVal, e) {
      // Determine thumb movement based on slider interaction
      if (!_this.isValid) {
        // Non-standard positioning follows
        _this._determineInvalidThumbMovement(newVal, _this.lowerValue, _this.upperValue, e);
      } else {
        // Standard positioning based on click event proximity to thumb locations
        _this._determineValidThumbMovement(newVal, _this.lowerValue, _this.upperValue, e);
      }
    });
    _defineProperty(_this, "_handleOnChange", function (lower, upper, e) {
      var isValid = (0, _number.isWithinRange)(_this.props.min, upper, lower) && (0, _number.isWithinRange)(lower, _this.props.max, upper);
      _this.props.onChange([lower, upper], isValid, e);
    });
    _defineProperty(_this, "handleSliderChange", function (e) {
      _this._determineThumbMovement(Number(e.currentTarget.value), e);
    });
    _defineProperty(_this, "_resetToRangeEnds", function (e) {
      // Arbitrary decision to pass `min` instead of `max`. Result is the same.
      _this._determineInvalidThumbMovement(_this.props.min, _this.lowerValue, _this.upperValue, e);
    });
    _defineProperty(_this, "_isDirectionalKeyPress", function (event) {
      return [_services.keys.ARROW_UP, _services.keys.ARROW_RIGHT, _services.keys.ARROW_DOWN, _services.keys.ARROW_LEFT].indexOf(event.key) > -1;
    });
    _defineProperty(_this, "handleInputKeyDown", function (e) {
      // Relevant only when initial values are both `''` and `showInput` is set
      if (_this._isDirectionalKeyPress(e) && !_this.isValid) {
        e.preventDefault();
        _this._resetToRangeEnds(e);
      }
    });
    _defineProperty(_this, "handleLowerInputChange", function (e) {
      _this._handleOnChange(e.target.value, _this.upperValue, e);
    });
    _defineProperty(_this, "handleUpperInputChange", function (e) {
      _this._handleOnChange(_this.lowerValue, e.target.value, e);
    });
    _defineProperty(_this, "_handleKeyDown", function (value, event) {
      var newVal = Number(value);
      var stepRemainder = 0;
      var step = _this.props.step || 1;
      var min = _this.props.min;
      switch (event.key) {
        case _services.keys.ARROW_UP:
        case _services.keys.ARROW_RIGHT:
          event.preventDefault();
          newVal += step;
          stepRemainder = (newVal - min) % step;
          if (step !== 1 && stepRemainder > 0) {
            newVal = newVal - stepRemainder;
          }
          break;
        case _services.keys.ARROW_DOWN:
        case _services.keys.ARROW_LEFT:
          event.preventDefault();
          newVal -= step;
          stepRemainder = (newVal - min) % step;
          if (step !== 1 && stepRemainder > 0) {
            newVal = newVal + (step - stepRemainder);
          }
          break;
      }
      return newVal;
    });
    _defineProperty(_this, "handleLowerKeyDown", function (event) {
      var lower = _this.lowerValue;
      switch (event.key) {
        case _services.keys.TAB:
          return;
        default:
          if (!_this.lowerValueIsValid) {
            // Relevant only when initial value is `''` and `showInput` is not set
            event.preventDefault();
            _this._resetToRangeEnds(event);
            return;
          }
          lower = _this._handleKeyDown(lower, event);
      }
      if (lower >= Number(_this.upperValue) || lower < _this.props.min) return;
      _this._handleOnChange(lower, _this.upperValue, event);
    });
    _defineProperty(_this, "handleUpperKeyDown", function (event) {
      var upper = _this.upperValue;
      switch (event.key) {
        case _services.keys.TAB:
          return;
        default:
          if (!_this.upperValueIsValid) {
            // Relevant only when initial value is `''` and `showInput` is not set
            event.preventDefault();
            _this._resetToRangeEnds(event);
            return;
          }
          upper = _this._handleKeyDown(upper, event);
      }
      if (upper <= Number(_this.lowerValue) || upper > _this.props.max) return;
      _this._handleOnChange(_this.lowerValue, upper, event);
    });
    _defineProperty(_this, "handleDraggableKeyDown", function (event) {
      var lower = _this.lowerValue;
      var upper = _this.upperValue;
      switch (event.key) {
        case _services.keys.TAB:
          return;
        default:
          lower = _this._handleKeyDown(lower, event);
          upper = _this._handleKeyDown(upper, event);
      }
      if (lower >= Number(_this.upperValue) || lower < _this.props.min) return;
      if (upper <= Number(_this.lowerValue) || upper > _this.props.max) return;
      _this._handleOnChange(lower, upper, event);
    });
    _defineProperty(_this, "calculateThumbPositionStyle", function (value, width) {
      var trackWidth = _this.isInPopover && !!width ? width : _this.state.rangeWidth;
      var position = (0, _utils.calculateThumbPosition)(value, _this.props.min, _this.props.max, trackWidth);
      return {
        left: "".concat(position, "%")
      };
    });
    _defineProperty(_this, "onThumbFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
    });
    _defineProperty(_this, "onThumbBlur", function (e) {
      if (_this.props.onBlur) {
        _this.props.onBlur(e);
      }
    });
    _defineProperty(_this, "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
      _this.preventPopoverClose = true;
      _this.setState({
        isPopoverOpen: true
      });
    });
    _defineProperty(_this, "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessible via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }
        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }
        _this.closePopover();
      }, 200);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.preventPopoverClose = false;
      _this.setState({
        isPopoverOpen: false
      });
    });
    _defineProperty(_this, "setRangeWidth", function (_ref) {
      var width = _ref.width;
      _this.setState({
        rangeWidth: width
      });
    });
    _defineProperty(_this, "getNearestStep", function (value) {
      var min = _this.props.min;
      var max = _this.props.max;
      var steps = (_this.props.max - _this.props.min) / _this.props.step;
      var approx = Math.round((value - min) * steps / (max - min)) / steps;
      var bound = Math.min(Math.max(approx, 0), 1);
      var nearest = bound * (max - min) + min;
      return Number(nearest.toPrecision(10)) * 100 / 100;
    });
    _defineProperty(_this, "handleDrag", function (x, isFirstInteraction) {
      if (isFirstInteraction) {
        _this.leftPosition = x;
        _this.dragAcc = 0;
      }
      var min = _this.props.min;
      var max = _this.props.max;
      var lowerValue = Number(_this.lowerValue);
      var upperValue = Number(_this.upperValue);
      var delta = _this.leftPosition - x;
      _this.leftPosition = x;
      _this.dragAcc = _this.dragAcc + delta;
      var percentageOfArea = _this.dragAcc / _this.state.rangeWidth;
      var percentageOfRange = percentageOfArea * (max - min);
      var newLower = _this.getNearestStep(lowerValue - percentageOfRange);
      var newUpper = _this.getNearestStep(upperValue - percentageOfRange);
      var noMovement = newLower === lowerValue;
      var isMin = min === lowerValue && min === newLower;
      var isMax = max === upperValue && max === newUpper;
      var isOutOfRange = newLower < min || newUpper > max;
      if (noMovement || isMin || isMax || isOutOfRange) return;
      _this._handleOnChange(newLower, newUpper);
      _this.dragAcc = 0;
    });
    return _this;
  }
  _inherits(EuiDualRangeClass, _Component);
  return _createClass(EuiDualRangeClass, [{
    key: "isInPopover",
    get: function get() {
      return this.props.showInput === 'inputWithPopover';
    }
  }, {
    key: "lowerValue",
    get: function get() {
      return this.props.value ? this.props.value[0] : this.props.min;
    }
  }, {
    key: "upperValue",
    get: function get() {
      return this.props.value ? this.props.value[1] : this.props.max;
    }
  }, {
    key: "lowerValueIsValid",
    get: function get() {
      return (0, _number.isWithinRange)(this.props.min, this.upperValue, this.lowerValue);
    }
  }, {
    key: "upperValueIsValid",
    get: function get() {
      return (0, _number.isWithinRange)(this.lowerValue, this.props.max, this.upperValue);
    }
  }, {
    key: "isValid",
    get: function get() {
      return this.lowerValueIsValid && this.upperValueIsValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref2 = this.context,
        defaultFullWidth = _ref2.defaultFullWidth;
      var _this$props = this.props,
        className = _this$props.className,
        customCss = _this$props.css,
        compressed = _this$props.compressed,
        disabled = _this$props.disabled,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        isLoading = _this$props.isLoading,
        readOnly = _this$props.readOnly,
        propsId = _this$props.id,
        maxProps = _this$props.max,
        minProps = _this$props.min,
        name = _this$props.name,
        step = _this$props.step,
        showLabels = _this$props.showLabels,
        showInput = _this$props.showInput,
        showTicks = _this$props.showTicks,
        tickInterval = _this$props.tickInterval,
        ticks = _this$props.ticks,
        levels = _this$props.levels,
        _onBlur = _this$props.onBlur,
        onChange = _this$props.onChange,
        _onFocus = _this$props.onFocus,
        showRange = _this$props.showRange,
        value = _this$props.value,
        isInvalid = _this$props.isInvalid,
        append = _this$props.append,
        prepend = _this$props.prepend,
        minInputProps = _this$props.minInputProps,
        maxInputProps = _this$props.maxInputProps,
        inputPopoverProps = _this$props.inputPopoverProps,
        isDraggable = _this$props.isDraggable,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var min = minProps;
      var max = maxProps;
      var id = this.state.id;
      var showInputOnly = this.isInPopover;
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var rangeStyles = (0, _range.euiRangeStyles)(theme);
      var minInput = !!showInput ? (0, _react2.jsx)(_range_input.EuiRangeInput
      // Overridable props
      , _extends({
        "aria-describedby": this.props['aria-describedby'],
        "aria-label": this.props['aria-label'],
        disabled: disabled,
        isInvalid: isInvalid,
        name: "".concat(name, "-minValue"),
        value: this.lowerValue,
        readOnly: readOnly
      }, minInputProps, {
        // Non-overridable props
        side: "min",
        min: min,
        max: this.upperValue === '' ? max : Number(this.upperValue),
        step: step,
        compressed: compressed,
        autoSize: !showInputOnly,
        fullWidth: !!showInputOnly && fullWidth,
        controlOnly: showInputOnly,
        onChange: function onChange(event) {
          var _minInputProps$onChan;
          _this2.handleLowerInputChange(event);
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onChan = minInputProps.onChange) === null || _minInputProps$onChan === void 0 || _minInputProps$onChan.call(minInputProps, event);
        },
        onKeyDown: function onKeyDown(event) {
          var _minInputProps$onKeyD;
          _this2.handleInputKeyDown(event);
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onKeyD = minInputProps.onKeyDown) === null || _minInputProps$onKeyD === void 0 || _minInputProps$onKeyD.call(minInputProps, event);
        },
        onFocus: function onFocus(event) {
          var _minInputProps$onFocu;
          if (canShowDropdown) {
            _this2.onInputFocus(event);
          } else {
            _onFocus === null || _onFocus === void 0 || _onFocus(event);
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onFocu = minInputProps.onFocus) === null || _minInputProps$onFocu === void 0 || _minInputProps$onFocu.call(minInputProps, event);
        },
        onBlur: function onBlur(event) {
          var _minInputProps$onBlur;
          if (canShowDropdown) {
            _this2.onInputBlur(event);
          } else {
            _onBlur === null || _onBlur === void 0 || _onBlur(event);
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onBlur = minInputProps.onBlur) === null || _minInputProps$onBlur === void 0 || _minInputProps$onBlur.call(minInputProps, event);
        },
        onMouseDown: function onMouseDown(event) {
          var _minInputProps$onMous;
          if (showInputOnly) {
            _this2.preventPopoverClose = true;
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onMous = minInputProps.onMouseDown) === null || _minInputProps$onMous === void 0 || _minInputProps$onMous.call(minInputProps, event);
        }
      })) : undefined;
      var maxInput = !!showInput ? (0, _react2.jsx)(_range_input.EuiRangeInput
      // Overridable props
      , _extends({
        "aria-describedby": this.props['aria-describedby'],
        "aria-label": this.props['aria-label'],
        disabled: disabled,
        isInvalid: isInvalid,
        name: "".concat(name, "-maxValue"),
        value: this.upperValue,
        readOnly: readOnly
      }, maxInputProps, {
        // Non-overridable props
        side: "max",
        min: this.lowerValue === '' ? min : Number(this.lowerValue),
        max: max,
        step: step,
        compressed: compressed,
        autoSize: !showInputOnly,
        fullWidth: !!showInputOnly && fullWidth,
        controlOnly: showInputOnly,
        onChange: function onChange(event) {
          var _maxInputProps$onChan;
          _this2.handleUpperInputChange(event);
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onChan = maxInputProps.onChange) === null || _maxInputProps$onChan === void 0 || _maxInputProps$onChan.call(maxInputProps, event);
        },
        onKeyDown: function onKeyDown(event) {
          var _maxInputProps$onKeyD;
          _this2.handleInputKeyDown(event);
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onKeyD = maxInputProps.onKeyDown) === null || _maxInputProps$onKeyD === void 0 || _maxInputProps$onKeyD.call(maxInputProps, event);
        },
        onFocus: function onFocus(event) {
          var _maxInputProps$onFocu;
          if (canShowDropdown) {
            _this2.onInputFocus(event);
          } else {
            _onFocus === null || _onFocus === void 0 || _onFocus(event);
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onFocu = maxInputProps.onFocus) === null || _maxInputProps$onFocu === void 0 || _maxInputProps$onFocu.call(maxInputProps, event);
        },
        onBlur: function onBlur(event) {
          var _maxInputProps$onBlur;
          if (canShowDropdown) {
            _this2.onInputBlur(event);
          } else {
            _onBlur === null || _onBlur === void 0 || _onBlur(event);
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onBlur = maxInputProps.onBlur) === null || _maxInputProps$onBlur === void 0 || _maxInputProps$onBlur.call(maxInputProps, event);
        },
        onMouseDown: function onMouseDown(event) {
          var _maxInputProps$onMous;
          if (showInputOnly) {
            _this2.preventPopoverClose = true;
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onMous = maxInputProps.onMouseDown) === null || _maxInputProps$onMous === void 0 || _maxInputProps$onMous.call(maxInputProps, event);
        }
      })) : undefined;
      var classes = (0, _classnames.default)('euiDualRange', className);
      var dualRangeStyles = (0, _dual_range.euiDualRangeStyles)();
      var cssStyles = [dualRangeStyles.euiDualRange, customCss];
      var leftThumbPosition = this.state.rangeWidth ? this.calculateThumbPositionStyle(Number(this.lowerValue) || min, this.state.rangeWidth) : {
        left: '0'
      };
      var rightThumbPosition = this.state.rangeWidth ? this.calculateThumbPositionStyle(Number(this.upperValue) || max, this.state.rangeWidth) : {
        left: '0'
      };
      var leftThumbColor = levels && (0, _range_levels_colors.getLevelColor)(levels, Number(this.lowerValue));
      var rightThumbColor = levels && (0, _range_levels_colors.getLevelColor)(levels, Number(this.upperValue));
      var leftThumbStyles = leftThumbColor ? _objectSpread(_objectSpread({}, leftThumbPosition), {}, {
        '--euiRangeThumbColor': (0, _range_levels_colors.euiRangeLevelColor)(leftThumbColor, theme)
      }) : leftThumbPosition;
      var rightThumbStyles = rightThumbColor ? _objectSpread(_objectSpread({}, rightThumbPosition), {}, {
        '--euiRangeThumbColor': (0, _range_levels_colors.euiRangeLevelColor)(rightThumbColor, theme)
      }) : rightThumbPosition;
      var dualSliderScreenReaderInstructions = (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiDualRange.sliderScreenReaderInstructions",
        default: "You are in a custom range slider. Use the Up and Down arrow keys to change the minimum value. Press Tab to interact with the maximum value."
      });
      var theRange = (0, _react2.jsx)(_range_wrapper.EuiRangeWrapper, {
        css: cssStyles,
        className: classes,
        fullWidth: fullWidth,
        compressed: compressed
      }, showInput && !showInputOnly && (0, _react2.jsx)(_react.default.Fragment, null, minInput, (0, _react2.jsx)("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? rangeStyles.euiRange__slimHorizontalSpacer : rangeStyles.euiRange__horizontalSpacer
      })), showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), (0, _react2.jsx)(_range_track.EuiRangeTrack, {
        trackWidth: this.state.rangeWidth,
        compressed: compressed,
        disabled: disabled,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleSliderChange,
        value: value,
        "aria-hidden": showInput === true,
        showRange: showRange
      }, (0, _react2.jsx)(_range_slider.EuiRangeSlider, _extends({
        className: "euiDualRange__slider",
        css: dualRangeStyles.euiDualRange__slider,
        id: id,
        name: name,
        min: min,
        max: max,
        step: step,
        disabled: disabled,
        onChange: this.handleSliderChange,
        showTicks: showTicks,
        "aria-hidden": true,
        tabIndex: -1,
        showRange: showRange,
        onFocus: _onFocus,
        onBlur: _onBlur
      }, rest, {
        onResize: this.setRangeWidth
      })), isDraggable && this.isValid && (0, _react2.jsx)(_range_draggable.EuiRangeDraggable, {
        min: min,
        max: max,
        value: [this.lowerValue, this.upperValue],
        disabled: disabled,
        lowerPosition: leftThumbPosition.left,
        upperPosition: rightThumbPosition.left,
        showTicks: showTicks,
        onChange: this.handleDrag,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        onKeyDown: this.handleDraggableKeyDown,
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), (0, _react2.jsx)(_range_thumb.EuiRangeThumb, {
        min: min,
        max: Number(this.upperValue),
        value: this.lowerValue,
        disabled: disabled,
        showTicks: showTicks,
        showInput: !!showInput,
        onKeyDown: this.handleLowerKeyDown,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        style: (0, _global_styling.logicalStyles)(leftThumbStyles),
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), (0, _react2.jsx)(_range_thumb.EuiRangeThumb, {
        min: Number(this.lowerValue),
        max: max,
        value: this.upperValue,
        disabled: disabled,
        showTicks: showTicks,
        showInput: !!showInput,
        onKeyDown: this.handleUpperKeyDown,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        style: (0, _global_styling.logicalStyles)(rightThumbStyles),
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), showRange && this.isValid && (0, _react2.jsx)(_range_highlight.EuiRangeHighlight, {
        showTicks: showTicks,
        min: Number(min),
        max: Number(max),
        lowerValue: Number(this.lowerValue),
        upperValue: Number(this.upperValue),
        levels: levels,
        trackWidth: this.state.rangeWidth
      })), showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        disabled: disabled
      }, max), showInput && !showInputOnly && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? rangeStyles.euiRange__slimHorizontalSpacer : rangeStyles.euiRange__horizontalSpacer
      }), maxInput));
      var thePopover = showInputOnly ? (0, _react2.jsx)(_popover.EuiInputPopover, _extends({}, inputPopoverProps, {
        className: (0, _classnames.default)('euiDualRange__popover', inputPopoverProps === null || inputPopoverProps === void 0 ? void 0 : inputPopoverProps.className),
        input: (0, _react2.jsx)(_form_control_layout.EuiFormControlLayoutDelimited, {
          startControl: minInput,
          endControl: maxInput,
          isDisabled: disabled,
          fullWidth: fullWidth,
          compressed: compressed,
          readOnly: readOnly,
          append: append,
          prepend: prepend,
          isLoading: isLoading,
          isInvalid: isInvalid
        }),
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true,
        popoverScreenReaderText: dualSliderScreenReaderInstructions
      }), theRange) : undefined;
      return thePopover || theRange;
    }
  }]);
}(_react.Component);
_defineProperty(EuiDualRangeClass, "contextType", _eui_form_context.FormContext);
_defineProperty(EuiDualRangeClass, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: true,
  showTicks: false,
  levels: []
});
EuiDualRangeClass.propTypes = {
  /**
     * Creates a draggble highlighted range area
     */
  isDraggable: _propTypes.default.bool,
  onBlur: _propTypes.default.func,
  onFocus: _propTypes.default.func,
  /**
     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Intended to be used with aria attributes. Some attributes may be overwritten.
     */
  minInputProps: _propTypes.default.any,
  /**
     *  Intended to be used with aria attributes. Some attributes may be overwritten.
     */
  maxInputProps: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  value: _propTypes.default.any.isRequired,
  onChange: _propTypes.default.func.isRequired,
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired,
    accessibleLabel: _propTypes.default.string
  }).isRequired),
  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,
  /**
     * Create colored indicators for certain intervals.
     * An array of #EuiRangeLevel objects
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Pass `true` to displays an extra input control for direct manipulation.
     * Pass `"inputWithPopover"` to only show the input but show the range in a dropdown.
     */
  showInput: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["inputWithPopover"])]),
  /**
     * Shows static min/max labels on the sides of the range slider
     */
  showLabels: _propTypes.default.bool,
  /**
     * Shows a thick line from min to value
     */
  showRange: _propTypes.default.bool,
  /**
     * Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)
     */
  showTicks: _propTypes.default.bool,
  id: _propTypes.default.string,
  name: _propTypes.default.string,
  /**
     * Only impacts ticks rendered by `showTicks` or inputs rendered by `showInput`.
     */
  compressed: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop.
     * The range slider itself remains interactable unless `disabled` is applied.
     */
  readOnly: _propTypes.default.bool,
  /**
     * Disables both the range track and any input(s)
     */
  disabled: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop
     */
  isInvalid: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`
     */
  isLoading: _propTypes.default.bool,
  /**
     * Only impacts input popovers rendered when the `showInput` prop is set to `"inputWithPopover"`
     *
     * Allows customizing the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element),
     * except for props controlled by the range component
     */
  inputPopoverProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Alignment of the popover relative to the input
       */
    anchorPosition: _propTypes.default.oneOf(["downLeft", "downRight", "downCenter"]),
    /**
       * Allows automatically closing the input popover on page scroll
       */
    closeOnScroll: _propTypes.default.bool,
    inputRef: _propTypes.default.any,
    onPanelResize: _propTypes.default.func,
    /**
       * By default, **EuiInputPopovers** inherit the same width as the passed input element.
       * However, if the input width is too small, you can pass a minimum panel width
       * (that should be based on the popover content).
       */
    panelMinWidth: _propTypes.default.number
  })
};
var EuiDualRange = exports.EuiDualRange = (0, _services.withEuiTheme)(EuiDualRangeClass);