"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DroppableColumns = exports.DraggableColumn = exports.DragOverlay = exports.ConditionalDroppableColumns = exports.ConditionalDraggableColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../../services");
var _drag_and_drop = require("../../../drag_and_drop");
var _portal = require("../../../portal");
var _focus = require("../../utils/focus");
var _data_grid = require("../../data_grid.styles");
var _draggable_columns = require("./draggable_columns.styles");
var _react2 = require("@emotion/react");
var _excluded = ["role", "tabIndex"],
  _excluded2 = ["canDragAndDropColumns", "children"],
  _excluded3 = ["canDragAndDropColumns", "children"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * Parent context + EuiDroppable wrapper
 */
var DroppableColumns = exports.DroppableColumns = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var columns = _ref.columns,
    switchColumnPos = _ref.switchColumnPos,
    indexOffset = _ref.indexOffset,
    children = _ref.children;
  var styles = (0, _services.useEuiMemoizedStyles)(_draggable_columns.euiDataGridDraggableHeaderStyles);
  var droppableId = (0, _services.useGeneratedHtmlId)({
    prefix: 'euiDataGridHeaderDroppable'
  });
  var _useContext = (0, _react.useContext)(_focus.DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell;
  var handleOnDragEnd = (0, _react.useCallback)(function (_ref2) {
    var source = _ref2.source,
      destination = _ref2.destination;
    if (!source) return;
    if (destination && destination.index !== source.index) {
      var sourceColumn = columns[source.index - indexOffset];
      var destinationColumn = columns[destination.index - indexOffset];
      if (sourceColumn && destinationColumn) {
        switchColumnPos(sourceColumn.id, destinationColumn.id);
      }
    }
    // Force focus the cell to prevent the datagrid body from become unfocusable, including on drag cancel
    setTimeout(function () {
      var cellToFocus = destination ? destination.index : source.index;
      setFocusedCell([cellToFocus, -1], true);
    });
  }, [columns, indexOffset, switchColumnPos, setFocusedCell]);
  return (0, _react2.jsx)(_drag_and_drop.EuiDragDropContext, {
    onDragEnd: handleOnDragEnd
  }, (0, _react2.jsx)(_drag_and_drop.EuiDroppable, {
    droppableId: droppableId,
    direction: "horizontal",
    ignoreContainerClipping: true,
    css: styles.euiDataGridHeaderDroppable,
    "data-test-subj": "euiDataGridHeaderDroppable"
  }, children));
});
DroppableColumns.propTypes = {
  indexOffset: _propTypes.default.number.isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired, _propTypes.default.any.isRequired]).isRequired
};
DroppableColumns.displayName = 'DroppableColumns';

/**
 * Individual EuiDraggable columns
 */
var DraggableColumn = exports.DraggableColumn = /*#__PURE__*/(0, _react.memo)(function (_ref3) {
  var id = _ref3.id,
    index = _ref3.index,
    gridStyles = _ref3.gridStyles,
    columnResizer = _ref3.columnResizer,
    actionsPopoverToggle = _ref3.actionsPopoverToggle,
    children = _ref3.children;
  var dataGridStyles = (0, _services.useEuiMemoizedStyles)(_data_grid.euiDataGridStyles);
  var styles = (0, _services.useEuiMemoizedStyles)(_draggable_columns.euiDataGridDraggableHeaderStyles);
  // Manually re-apply background and border overrides, since
  // the droppable zone sets its own and confuses :first-of-type CSS
  var reapplyCellStyles = [styles[gridStyles.header], index !== 0 && styles.noLeadingBorder];

  // Draggable prevents the cell from receiving focus on click.
  // We manually ensure focus is set on cell mouseDown which
  // also includes setting focus before dragging
  var _useContext2 = (0, _react.useContext)(_focus.DataGridFocusContext),
    setFocusedCell = _useContext2.setFocusedCell;
  var handleOnMouseDown = (0, _react.useCallback)(function (e) {
    var openFocusTraps = document.querySelectorAll('[data-focus-lock-disabled="false"]');
    var validOpenFocusTraps = _toConsumableArray(openFocusTraps).filter(function (focusTrap) {
      return !focusTrap.contains(e.currentTarget);
    } // remove containing focus traps (e.g. modals or flyouts)
    );
    var shouldDispatchEvent = validOpenFocusTraps.some(function (focusTrap) {
      return !!focusTrap &&
      // If there is a focus trap open
      !focusTrap.contains(e.target) &&
      // & if it doesn't contain the target
      e.target !== actionsPopoverToggle;
    } // & we're not closing the actions popover toggle
    );
    if (shouldDispatchEvent) {
      // Trick the focus trap lib into registering an outside click -
      // the drag/drop lib otherwise prevents the event 💀
      document.dispatchEvent(new MouseEvent('mousedown'));
    }
    setTimeout(function () {
      setFocusedCell([index, -1], true);
    });
  }, [setFocusedCell, index, actionsPopoverToggle]);

  // Prevent any other keypresses when dragging
  var isDraggingRef = (0, _react.useRef)(false);
  var handleOnKeydown = (0, _react.useCallback)(function (e) {
    if (isDraggingRef.current) {
      e.preventDefault();
      e.stopPropagation();
      return false;
    }
  }, []);

  // UX polish: add a slight animation frame delay to the dragging ref end
  // which prevents re-running the hover animation of column header actions
  var updateDraggingRef = (0, _react.useCallback)(function (isDragging) {
    // Only update if the state has changed from before
    if (isDragging !== isDraggingRef.current) {
      if (!isDragging) {
        requestAnimationFrame(function () {
          isDraggingRef.current = false;
        });
      } else {
        isDraggingRef.current = true;
      }
    }
  }, []);
  return (0, _react2.jsx)("div", {
    css: styles.euiDataGridHeaderCellDraggableWrapper,
    onMouseDown: handleOnMouseDown,
    onKeyDownCapture: handleOnKeydown
  }, columnResizer, (0, _react2.jsx)(_drag_and_drop.EuiDraggable, {
    draggableId: id,
    className: "euiDataGridHeaderCellDraggable",
    css: styles.euiDataGridHeaderCellDraggable,
    index: index,
    customDragHandle: "custom",
    hasInteractiveChildren: true,
    usePortal: true
  }, function (_ref4, _ref5) {
    var dragHandleProps = _ref4.dragHandleProps;
    var isDragging = _ref5.isDragging,
      mode = _ref5.mode;
    updateDraggingRef(isDragging);
    var _ref6 = dragHandleProps !== null && dragHandleProps !== void 0 ? dragHandleProps : {},
      role = _ref6.role,
      tabIndex = _ref6.tabIndex,
      restDragHandleProps = _objectWithoutProperties(_ref6, _excluded);
    var passedProps = _objectSpread(_objectSpread({}, restDragHandleProps), {}, {
      css: reapplyCellStyles,
      'data-column-moving': isDraggingRef.current || undefined,
      isDragging: isDragging
    });

    // since the cloned content is in a portal outside the datagrid
    // we need to re-add styles to the cell as the scoped styles
    // from the wrapper don't apply
    var draggingStyles = [styles.euiDataGridHeaderCellDraggable,
    // ensure height is maintained while dragging
    dataGridStyles.cellPadding[gridStyles.cellPadding], dataGridStyles.fontSize[gridStyles.fontSize], dataGridStyles.borders[gridStyles.border], mode === 'SNAP' && styles.isKeyboardDragging];
    return isDragging ? (0, _react2.jsx)("div", {
      css: draggingStyles
    }, (0, _react2.jsx)(DragOverlay, {
      isDragging: true,
      cursor: "grabbing"
    }), children(passedProps)) : children(passedProps);
  }));
});
DraggableColumn.propTypes = {
  id: _propTypes.default.string.isRequired,
  index: _propTypes.default.number.isRequired,
  gridStyles: _propTypes.default.shape({
    /**
       * Size of fonts used within the row and column cells
       * @default m
       */
    fontSize: _propTypes.default.oneOf(["s", "m", "l"]),
    /**
       * Defines the padding with the row and column cells
       * @default m
       */
    cellPadding: _propTypes.default.oneOf(["s", "m", "l"]),
    /**
       * Border used for the row and column cells
       * @default all
       */
    border: _propTypes.default.oneOf(["all", "horizontal", "none"]),
    /**
       * If set to true, rows will alternate zebra striping for clarity
       * @default false
       */
    stripes: _propTypes.default.bool,
    /**
       * Visual style for the column headers. Recommendation is to use the `underline` style in times when #EuiDataGrid `toolbarVisibility` is set to `false`.
       * @default shade
       */
    header: _propTypes.default.oneOf(["shade", "underline"]),
    /**
       * Visual style for the column footers.
       * @default overline
       */
    footer: _propTypes.default.oneOf(["shade", "overline", "striped"]),
    /**
       * If set to true, the footer row will be sticky
       * @default true
       */
    stickyFooter: _propTypes.default.bool,
    /**
       * Will define what visual style to show on row hover
       * @default hover
       */
    rowHover: _propTypes.default.oneOf(["highlight", "none"]),
    /**
       * Optionally pass custom classes to highlight or customize certain rows
       */
    rowClasses: _propTypes.default.shape({}),
    /**
       * Optional callback returning the current `gridStyle` config when changes occur from user input (e.g. toolbar display controls).
       * Can be used for, e.g. storing user `gridStyle` in a local storage object.
       */
    onChange: _propTypes.default.func
  }).isRequired,
  columnResizer: _propTypes.default.node,
  actionsPopoverToggle: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])]),
  children: _propTypes.default.func.isRequired
};
DraggableColumn.displayName = 'DraggableColumn';

/**
 * Components for conditionally rendering drag/drop wrappers
 * Allows us to conditionally call hooks while not instantiating a bunch
 * of extra state/etc., since draggable columns isn't yet(?) a default
 */

var ConditionalDroppableColumns = exports.ConditionalDroppableColumns = /*#__PURE__*/(0, _react.memo)(function (_ref7) {
  var canDragAndDropColumns = _ref7.canDragAndDropColumns,
    children = _ref7.children,
    rest = _objectWithoutProperties(_ref7, _excluded2);
  return canDragAndDropColumns ? (0, _react2.jsx)(DroppableColumns, rest, children) : (0, _react2.jsx)(_react.default.Fragment, null, children);
});
ConditionalDroppableColumns.propTypes = {
  canDragAndDropColumns: _propTypes.default.bool.isRequired
};
ConditionalDroppableColumns.displayName = 'ConditionalDroppableColumns';
var ConditionalDraggableColumn = exports.ConditionalDraggableColumn = /*#__PURE__*/(0, _react.memo)(function (_ref8) {
  var canDragAndDropColumns = _ref8.canDragAndDropColumns,
    children = _ref8.children,
    rest = _objectWithoutProperties(_ref8, _excluded3);
  return canDragAndDropColumns ? (0, _react2.jsx)(DraggableColumn, rest, children) : (0, _react2.jsx)(_react.default.Fragment, null, children());
});
ConditionalDraggableColumn.propTypes = {
  canDragAndDropColumns: _propTypes.default.bool.isRequired
};
ConditionalDraggableColumn.displayName = 'ConditionalDraggableColumn';

/**
 * Creates an invisible overlay that prevents hover interactions/transitions
 * on other elements that the dragged element is dragged over, and also maintains
 * the intended drag cursor over any location.
 *
 * TODO: If this is useful elsewhere, consider moving it to `src/services`
 */
var _ref10 = process.env.NODE_ENV === "production" ? {
  name: "q8wbl-DragOverlay",
  styles: "position:fixed;inset:0;label:DragOverlay;"
} : {
  name: "q8wbl-DragOverlay",
  styles: "position:fixed;inset:0;label:DragOverlay;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var DragOverlay = exports.DragOverlay = /*#__PURE__*/(0, _react.memo)(function (_ref9) {
  var isDragging = _ref9.isDragging,
    cursor = _ref9.cursor,
    _ref9$zIndex = _ref9.zIndex,
    zIndex = _ref9$zIndex === void 0 ? 9999 : _ref9$zIndex;
  return isDragging ? (0, _react2.jsx)(_portal.EuiPortal, null, (0, _react2.jsx)("div", {
    css: _ref10,
    style: {
      cursor: cursor,
      zIndex: zIndex
    }
  })) : null;
});
DragOverlay.propTypes = {
  isDragging: _propTypes.default.bool,
  cursor: _propTypes.default.any,
  zIndex: _propTypes.default.any
};
DragOverlay.displayName = 'DragOverlay';