"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSaturationStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiSaturationStyles = exports.euiSaturationStyles = function euiSaturationStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var indicatorSize = euiTheme.size.m;
  var borderRadius = euiTheme.border.radius.small;
  // Without this slight decrease in border radius, the color can be seen
  // peeking through the top left corner of the saturation gradient
  var gradientBorderRadius = (0, _global_styling.mathWithUnits)(borderRadius, function (x) {
    return x - 1;
  });
  return {
    euiSaturation: /*#__PURE__*/(0, _react.css)("z-index:3;position:relative;aspect-ratio:1/1;", (0, _global_styling.logicalCSS)('width', '100%'), " border-radius:", borderRadius, ";touch-action:none;&:focus,&:focus-within{outline:none;.euiSaturation__indicator{", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n              outline: none; /* Standardize indicator focus ring */\n              box-shadow: 0 0 0 ".concat(euiTheme.focus.width, " ").concat(euiTheme.colors.primary, ";\n              border-color: ").concat(euiTheme.colors.primary, ";\n            "),
      preferred: "\n              outline: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.ink, ";\n              outline-offset: 0;\n            ")
    }), ";}}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // The border must be in an overlaid pseudo element to not affect the
      // width/height/position of the indicator, or cause border-radius issues
      preferred: "\n          &::after {\n            z-index: 1;\n            content: '';\n            position: absolute;\n            inset: 0;\n            border: ".concat(euiTheme.border.thin, ";\n            border-radius: inherit;\n            pointer-events: none;\n          }\n        "),
      forced: (0, _high_contrast.preventForcedColors)(euiThemeContext)
    }), ";;label:euiSaturation;"),
    euiSaturation__lightness: /*#__PURE__*/(0, _react.css)("position:absolute;inset:0;border-radius:", gradientBorderRadius, ";background:linear-gradient(\n        to right,\n        rgba(255, 255, 255, 1),\n        rgba(255, 255, 255, 0)\n      );;label:euiSaturation__lightness;"),
    euiSaturation__saturation: /*#__PURE__*/(0, _react.css)("position:absolute;inset:0;border-radius:", gradientBorderRadius, ";background:linear-gradient(to top, rgba(0, 0, 0, 1), rgba(0, 0, 0, 0));;label:euiSaturation__saturation;"),
    euiSaturation__indicator: /*#__PURE__*/(0, _react.css)("z-index:2;position:absolute;", (0, _global_styling.logicalSizeCSS)(indicatorSize), " transform:translateX(-50%) translateY(-50%);border-radius:100%;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          border: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.darkestShade, ";\n\n          &::before {\n            content: '';\n            position: absolute;\n            inset: 0;\n            border-radius: 100%;\n            border: ").concat(euiTheme.border.width.thin, " solid\n              ").concat(euiTheme.colors.lightestShade, ";\n          }\n        "),
      preferred: "\n          border: ".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.ink, ";\n          background-color: ").concat(euiTheme.colors.ghost, ";\n        ")
    }), ";;label:euiSaturation__indicator;")
  };
};