"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaCollapsibleNavSolution = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _popover = require("../../popover");
var _list_group = require("../../list_group");
var _context = require("../context");
var _collapsible_nav_link = require("../collapsible_nav_item/collapsible_nav_link");
var _collapsible_nav_item = require("../collapsible_nav_item/collapsible_nav_item");
var _collapsed_nav_popover = require("../collapsible_nav_item/collapsed/collapsed_nav_popover");
var _collapsible_nav_kibana_solution = require("./collapsible_nav_kibana_solution.styles");
var _react2 = require("@emotion/react");
var _excluded = ["title", "icon", "solutions", "items", "className"],
  _excluded2 = ["title", "icon", "isSecondary"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * This component should only ever be used as a **top-level component**.
 * It also should **not** be used in the nav footer.
 *
 * This component is **very** specific to Kibana and is not meant to be a generic component.
 */
var KibanaCollapsibleNavSolution = exports.KibanaCollapsibleNavSolution = function KibanaCollapsibleNavSolution(_ref) {
  var title = _ref.title,
    icon = _ref.icon,
    _ref$solutions = _ref.solutions,
    solutions = _ref$solutions === void 0 ? [] : _ref$solutions,
    items = _ref.items,
    className = _ref.className,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isSolutionSwitcherOpen = _useState2[0],
    setIsSolutionSwitcherOpen = _useState2[1];
  var classes = (0, _classnames.default)('kibanaCollapsibleNavSolution', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_kibana_solution.euiCollapsibleNavKibanaSolutionStyles);
  var cssStyles = [styles.euiCollapsibleNavKibanaSolution, isPush && isCollapsed ? styles.collapsed : styles.uncollapsed];
  var solutionSwitcherIcon = 'layers';
  var solutionSolutionSwitcherTitle = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.switcherTitle', 'Solution view');
  var solutionSolutionSwitcherAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.switcherAriaLabel', ' - click to switch to another solution');
  var solutionSolutionGroupLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.groupLabel', 'Navigate to solution');
  var closeSolutionPopover = (0, _react.useCallback)(function (event) {
    var _childItem$firstEleme;
    // Allow child items to stop the popover from being closed
    if (event.isPropagationStopped()) return;
    // Only listen for clicks on child items - currentTarget is the parent <ul>
    if (event.target === event.currentTarget) return;

    // Only close the popover if the item is a clickable link or button
    var target = event.target;
    var childItem = target.closest('.euiListGroupItem');
    if (['A', 'BUTTON'].includes((childItem === null || childItem === void 0 || (_childItem$firstEleme = childItem.firstElementChild) === null || _childItem$firstEleme === void 0 ? void 0 : _childItem$firstEleme.tagName) || '')) {
      setIsSolutionSwitcherOpen(false);
    }
  }, []);
  var solutionSwitcherContent = (0, _react.useMemo)(function () {
    var _parseListItems = parseListItems(solutions),
      _parseListItems2 = _slicedToArray(_parseListItems, 2),
      primaryItems = _parseListItems2[0],
      secondaryItems = _parseListItems2[1];
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_list_group.EuiListGroup, {
      "data-test-subj": "kibanaSolutionSwitcherList",
      "aria-label": solutionSolutionGroupLabel,
      listItems: primaryItems,
      size: "s",
      bordered: true,
      onClick: closeSolutionPopover
    }), secondaryItems.length > 0 && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_list_group.EuiListGroup, {
      listItems: secondaryItems,
      size: "s",
      css: styles.euiCollapsibleNavKibanaSolution__secondaryItems,
      onClick: closeSolutionPopover
    })));
  }, [solutions, solutionSolutionGroupLabel, closeSolutionPopover, styles]);
  var sharedPopoverProps = {
    'aria-label': solutionSolutionSwitcherTitle,
    panelProps: {
      css: styles.euiCollapsibleNavKibanaSolution__switcherPopover
    },
    panelPaddingSize: 's',
    display: 'block'
  };
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles
  }, props), isCollapsed && isPush ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, {
    icon: icon,
    title: title,
    items: items
  }), (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, _extends({}, sharedPopoverProps, {
    icon: solutionSwitcherIcon,
    title: solutionSolutionSwitcherTitle,
    items: [{
      renderItem: function renderItem() {
        return solutionSwitcherContent;
      }
    }],
    "data-test-subj": "kibanaSolutionSwitcherDocked"
  }))) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_popover.EuiInputPopover, _extends({}, sharedPopoverProps, {
    fullWidth: true
    // Use the default EuiPopover focus trap, not the EuiInputPopover focus trap
    ,
    disableFocusTrap: true,
    ownFocus: true,
    isOpen: isSolutionSwitcherOpen,
    closePopover: function closePopover() {
      return setIsSolutionSwitcherOpen(false);
    },
    input: (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
      css: styles.euiCollapsibleNavKibanaSolution__title,
      onClick: function onClick() {
        return setIsSolutionSwitcherOpen(function (isOpen) {
          return !isOpen;
        });
      },
      isInteractive: true,
      isSelected: isSolutionSwitcherOpen,
      "data-test-subj": "kibanaSolutionSwitcher"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: icon,
      css: styles.euiCollapsibleNavKibanaSolution__logo
    }), title, (0, _react2.jsx)(_icon.EuiIcon, {
      type: solutionSwitcherIcon,
      css: styles.euiCollapsibleNavKibanaSolution__switcherIcon,
      "aria-label": solutionSolutionSwitcherAriaLabel
    }))
  }), (0, _react2.jsx)(_popover.EuiPopoverTitle, null, solutionSolutionSwitcherTitle), solutionSwitcherContent), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    role: "group",
    "aria-label": title
  })));
};

/**
 * Tweak EuiListGroup's items API to match EuiCollapsibleNav's
 * more closely (primarily label->title, iconType->icon),
 * and also to allow passing secondary items in the same array
 * (which will get rendered in a separate non-bordered group)
 */
KibanaCollapsibleNavSolution.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  solutions: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * Size of the label text
         */
    size: _propTypes.default.any,
    /**
         * By default the item will get the color `text`.
         * You can customize the color of the item by passing a color name.
         */
    color: _propTypes.default.any,
    /**
         * Apply styles indicating an item is active
         */
    isActive: _propTypes.default.bool,
    /**
         * Apply styles indicating an item is disabled
         */
    isDisabled: _propTypes.default.bool,
    /**
         * Make the list item label a link.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    target: _propTypes.default.string,
    /**
         * Set to true to show an icon indicating that it is an external link;
         * Defaults to true if `target="_blank"`
         */
    external: _propTypes.default.bool,
    /**
         * Further extend the props applied to EuiIcon
         */
    iconProps: _propTypes.default.any,
    /**
         * Display tooltip on list item
         */
    showToolTip: _propTypes.default.bool,
    /**
         * An object of #EuiListGroupItemExtraAction props.
         * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
         * pass `alwaysShow` if you don't want the default behavior of only showing on hover
         */
    extraAction: _propTypes.default.shape({
      alwaysShow: _propTypes.default.bool,
      type: _propTypes.default.any,
      onClick: _propTypes.default.func,
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
      /**
         * Any of the named color palette options.
         */
      color: _propTypes.default.any,
      "aria-label": _propTypes.default.string,
      "aria-labelledby": _propTypes.default.string,
      isDisabled: _propTypes.default.bool,
      /**
         * Overall size of button.
         * Matches the sizes of other EuiButtons
         */
      size: _propTypes.default.any,
      /**
         * Size of the icon only.
         * This will not affect the overall size of the button
         */
      iconSize: _propTypes.default.any,
      /**
         * Applies the boolean state as the `aria-pressed` property to create a toggle button.
         * *Only use when the readable text does not change between states.*
         */
      isSelected: _propTypes.default.bool,
      /**
         * Sets the display style for matching other EuiButton types.
         * `base` is equivalent to a typical EuiButton
         * `fill` is equivalent to a filled EuiButton
         * `empty` (default) is equivalent to an EuiButtonEmpty
         */
      display: _propTypes.default.any,
      /**
         * Disables the button and changes the icon to a loading spinner
         */
      isLoading: _propTypes.default.bool,
      className: _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      buttonRef: _propTypes.default.any
    }),
    /**
         * Make the list item label a button.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    onClick: _propTypes.default.func,
    /**
         * Allow link text to wrap
         */
    wrapText: _propTypes.default.bool,
    /**
         * Pass-through ref reference specifically for targeting
         * instances where the item content is rendered as a `button`
         */
    buttonRef: _propTypes.default.any,
    /**
         * Text to be displayed in the tooltip when `showToolTip` is true.
         * By default the text will be same as the label text.
         */
    toolTipText: _propTypes.default.string,
    /**
         * Allows customizing the tooltip shown when `showToolTip` is true.
         * Accepts any props that [EuiToolTip](/#/display/tooltip) accepts.
         */
    toolTipProps: _propTypes.default.any,
    title: _propTypes.default.string.isRequired,
    icon: _propTypes.default.any,
    isSecondary: _propTypes.default.bool
  }).isRequired).isRequired
};
var parseListItems = function parseListItems(items) {
  var primaryItems = [];
  var secondaryItems = [];
  items.forEach(function (_ref2) {
    var title = _ref2.title,
      icon = _ref2.icon,
      isSecondary = _ref2.isSecondary,
      item = _objectWithoutProperties(_ref2, _excluded2);
    var arrayToPushTo = isSecondary ? secondaryItems : primaryItems;
    arrayToPushTo.push(_objectSpread(_objectSpread({}, item), {}, {
      label: title,
      iconType: icon
    }));
  });
  return [primaryItems, secondaryItems];
};