"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _color_utils = require("./color_utils");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;"
} : {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBadgeStyles = exports.euiBadgeStyles = function euiBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var badgeColors = (0, _color_utils.euiBadgeColors)(euiThemeContext);
  var setBadgeColorVars = function setBadgeColorVars(colors) {
    return "\n    --euiBadgeTextColor: ".concat(colors.color, ";\n    --euiBadgeBackgroundColor: ").concat(colors.backgroundColor, ";\n  ");
  };
  return {
    euiBadge: /*#__PURE__*/(0, _react.css)("display:inline-block;vertical-align:middle;", (0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(euiTheme.size.s)), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";line-height:", (0, _global_styling.mathWithUnits)(
    // Account for the border
    [euiTheme.size.base, euiTheme.border.width.thin], function (x, y) {
      return x + y * 2;
    }), ";font-weight:", euiTheme.font.weight.medium, ";white-space:nowrap;text-decoration:none;cursor:inherit;border:", euiTheme.border.width.thin, " solid transparent;border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";", (0, _global_styling.logicalTextAlignCSS)('left'), "color:var(--euiBadgeTextColor, ", badgeColors.default.color, ");background-color:var(\n        --euiBadgeBackgroundColor,\n        ", badgeColors.default.backgroundColor, "\n      );*::selection{color:var(\n          --euiBadgeBackgroundColor,\n          ", badgeColors.default.backgroundColor, "\n        );background-color:var(\n          --euiBadgeTextColor,\n          ", badgeColors.default.color, "\n        );}&:focus-within{", (0, _global_styling.euiFocusRing)(euiThemeContext), ";}&+.euiBadge{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";};label:euiBadge;"),
    clickable: /*#__PURE__*/(0, _react.css)("&:not(:disabled){&:hover,&:focus{text-decoration:underline;}}&:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext), ";}&:disabled{cursor:not-allowed;};label:clickable;"),
    // Colors
    default: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.default), " border-color:", badgeColors.default.borderColor, ";;label:default;"),
    hollow: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.hollow), " border-color:", badgeColors.hollow.borderColor, ";;label:hollow;"),
    primary: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.primary), ";label:primary;"),
    accent: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.accent), ";label:accent;"),
    warning: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.warning), ";label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.danger), ";label:danger;"),
    success: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.success), ";label:success;"),
    disabled: /*#__PURE__*/(0, _react.css)(setBadgeColorVars(badgeColors.disabled), " border-color:", badgeColors.disabled.borderColor, ";*::selection{color:", euiTheme.colors.emptyShade, ";};label:disabled;"),
    // Content wrapper
    euiBadge__content: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)(
    // Ensure proper height in case of just displaying an icon
    'min-height', "".concat((0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return euiTheme.base + x * 2;
    }))), " display:flex;align-items:center;overflow:hidden;;label:euiBadge__content;"),
    // Text
    text: {
      euiBadge__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " cursor:inherit;;label:euiBadge__text;"),
      clickable: _ref
    },
    // Icon
    icon: {
      euiBadge__icon: /*#__PURE__*/(0, _react.css)(";label:euiBadge__icon;"),
      right: /*#__PURE__*/(0, _react.css)("&:not(:only-child){", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";};label:right;"),
      left: /*#__PURE__*/(0, _react.css)("&:not(:only-child){", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), ";};label:left;")
    },
    // Clickable icons (iconOnClick)
    iconButton: {
      euiBadge__iconButton: /*#__PURE__*/(0, _react.css)("font-size:0;&:focus{background-color:", euiTheme.components.badgeIconButtonBackgroundHover, ";color:", euiTheme.colors.ink, ";border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
        return x / 2;
      }), ";}&:disabled{cursor:not-allowed;}.euiBadge__icon{margin:0!important;};label:euiBadge__iconButton;"),
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";;label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), ";;label:left;")
    },
    // Used in badges with both onClick & iconOnClick
    euiBadge__childButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " text-align:inherit;font-weight:inherit;line-height:inherit;color:inherit;&:disabled{cursor:not-allowed;}&:not(:disabled){&:hover,&:focus{text-decoration:underline;}};label:euiBadge__childButton;")
  };
};