"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SEVERITY_COLORS = exports.DARK_BACKGROUND_COLORS_CUSTOM = exports.LIGHT_BACKGROUND_COLORS_CUSTOM = exports.LIGHT_BACKGROUND_COLORS = exports.DARK_BACKGROUND_COLORS = exports.LIGHT_TEXT_COLORS = exports.DARK_TEXT_COLORS = exports.LIGHT_BORDER_COLORS = exports.DARK_BORDER_COLORS = exports.SEMANTIC_ALPHA_COLORS = exports.SEMANTIC_COLORS = exports.PRIMITIVE_COLORS = void 0;
const chroma_js_1 = __importDefault(require("chroma-js"));
exports.PRIMITIVE_COLORS = {
    white: '#FFFFFF',
    blueBlack: '#07101F',
    blue30: '#BFDBFF',
    blue60: '#61A2FF',
    blue90: '#0B64DD',
    blue100: '#1750BA',
    blue120: '#123778',
    blueGrey15: '#ECF1F9',
    blueGrey20: '#E3E8F2',
    blueGrey30: '#CAD3E2',
    blueGrey60: '#8E9FBC',
    blueGrey70: '#798EAF',
    blueGrey80: '#6A7FA0',
    blueGrey90: '#5A6D8C',
    blueGrey95: '#516381',
    blueGrey100: '#485975',
    blueGrey120: '#2B394F',
    blueGrey130: '#1D2A3E',
    blueGrey140: '#111C2C',
    blueGrey145: '#0B1628',
    primary100: '#1750BA',
    red50: '#FC9188',
    red70: '#EE4C48',
    red90: '#C61E25',
    yellow30: '#FCD883',
    pink60: '#EE72A6',
    pink90: '#BC1E70',
};
exports.SEMANTIC_COLORS = {
    plainLight: exports.PRIMITIVE_COLORS.white,
    plainDark: exports.PRIMITIVE_COLORS.blueBlack,
    shade15: exports.PRIMITIVE_COLORS.blueGrey15,
    shade20: exports.PRIMITIVE_COLORS.blueGrey20,
    shade30: exports.PRIMITIVE_COLORS.blueGrey30,
    shade60: exports.PRIMITIVE_COLORS.blueGrey60,
    shade70: exports.PRIMITIVE_COLORS.blueGrey70,
    shade80: exports.PRIMITIVE_COLORS.blueGrey80,
    shade90: exports.PRIMITIVE_COLORS.blueGrey90,
    shade95: exports.PRIMITIVE_COLORS.blueGrey95,
    shade100: exports.PRIMITIVE_COLORS.blueGrey100,
    shade120: exports.PRIMITIVE_COLORS.blueGrey120,
    shade130: exports.PRIMITIVE_COLORS.blueGrey130,
    shade140: exports.PRIMITIVE_COLORS.blueGrey140,
    shade145: exports.PRIMITIVE_COLORS.blueGrey145,
    primary30: exports.PRIMITIVE_COLORS.blue30,
    primary60: exports.PRIMITIVE_COLORS.blue60,
    primary90: exports.PRIMITIVE_COLORS.blue90,
    primary100: exports.PRIMITIVE_COLORS.blue100,
    primary120: exports.PRIMITIVE_COLORS.blue120,
    accent60: exports.PRIMITIVE_COLORS.pink60,
    accent90: exports.PRIMITIVE_COLORS.pink90,
    danger50: exports.PRIMITIVE_COLORS.red50,
    danger70: exports.PRIMITIVE_COLORS.red70,
    danger90: exports.PRIMITIVE_COLORS.red90,
    warning30: exports.PRIMITIVE_COLORS.yellow30,
};
const primary100RGB = (0, chroma_js_1.default)(exports.SEMANTIC_COLORS.primary100).rgb().join(' ');
const plainLightRGB = (0, chroma_js_1.default)(exports.SEMANTIC_COLORS.plainLight).rgb().join(' ');
const shade145RGB = (0, chroma_js_1.default)(exports.SEMANTIC_COLORS.shade145).rgb().join(' ');
exports.SEMANTIC_ALPHA_COLORS = {
    primary100Alpha4: `rgba(${primary100RGB} / 0.04)`,
    plainLightAlpha8: `rgba(${plainLightRGB} / 0.08)`,
    plainLightAlpha70: `rgba(${plainLightRGB} / 0.7)`,
    shade145Alpha70: `rgba(${shade145RGB} / 0.7)`,
};
exports.DARK_BORDER_COLORS = {
    borderBaseSubdued: exports.SEMANTIC_COLORS.shade120,
    borderBasePlain: exports.SEMANTIC_COLORS.shade100,
    borderBasePrimary: exports.SEMANTIC_COLORS.primary120,
};
exports.LIGHT_BORDER_COLORS = {
    borderBaseSubdued: exports.SEMANTIC_COLORS.shade20,
    borderBasePlain: exports.SEMANTIC_COLORS.shade30,
    borderBasePrimary: exports.SEMANTIC_COLORS.primary30,
};
exports.DARK_TEXT_COLORS = {
    textParagraph: exports.SEMANTIC_COLORS.shade30,
    textHeading: exports.SEMANTIC_COLORS.shade20,
    textSubdued: exports.SEMANTIC_COLORS.shade60,
    textDisabled: exports.SEMANTIC_COLORS.shade80,
    textInverse: exports.SEMANTIC_COLORS.plainDark,
};
exports.LIGHT_TEXT_COLORS = {
    textParagraph: exports.SEMANTIC_COLORS.shade130,
    textHeading: exports.SEMANTIC_COLORS.shade140,
    textSubdued: exports.SEMANTIC_COLORS.shade95,
    textDisabled: exports.SEMANTIC_COLORS.shade70,
    textInverse: exports.SEMANTIC_COLORS.plainLight,
};
exports.DARK_BACKGROUND_COLORS = {
    backgroundBasePlain: exports.SEMANTIC_COLORS.shade145,
    backgroundBaseDisabled: exports.SEMANTIC_COLORS.shade130,
    backgroundBaseInteractiveHover: exports.SEMANTIC_ALPHA_COLORS.plainLightAlpha8,
    backgroundFilledPrimary: exports.SEMANTIC_COLORS.primary60,
    backgroundFilledText: exports.SEMANTIC_COLORS.shade90,
    backgroundFilledAccent: exports.SEMANTIC_COLORS.accent60,
};
exports.LIGHT_BACKGROUND_COLORS = {
    backgroundBasePlain: exports.SEMANTIC_COLORS.plainLight,
    backgroundBaseDisabled: exports.SEMANTIC_COLORS.shade15,
    backgroundBaseInteractiveHover: exports.SEMANTIC_ALPHA_COLORS.primary100Alpha4,
    backgroundFilledPrimary: exports.SEMANTIC_COLORS.primary90,
    backgroundFilledText: exports.SEMANTIC_COLORS.shade60,
    backgroundFilledAccent: exports.SEMANTIC_COLORS.accent90,
};
exports.LIGHT_BACKGROUND_COLORS_CUSTOM = {
    backgroundBasePlainAlpha70: exports.SEMANTIC_ALPHA_COLORS.plainLightAlpha70,
};
exports.DARK_BACKGROUND_COLORS_CUSTOM = {
    backgroundBasePlainAlpha70: exports.SEMANTIC_ALPHA_COLORS.shade145Alpha70,
};
exports.SEVERITY_COLORS = {
    euiColorSeverity5: exports.SEMANTIC_COLORS.shade30,
    euiColorSeverity7: exports.SEMANTIC_COLORS.warning30,
    euiColorSeverity10: exports.SEMANTIC_COLORS.danger50,
    euiColorSeverity12: exports.SEMANTIC_COLORS.danger70,
    euiColorSeverity14: exports.SEMANTIC_COLORS.danger90,
};
//# sourceMappingURL=base_colors.js.map