"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricState = void 0;
const react_1 = __importDefault(require("react"));
const can_display_chart_titles_1 = require("./selectors/can_display_chart_titles");
const __1 = require("../..");
const constants_1 = require("../../../common/constants");
const legend_1 = require("../../../common/legend");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
const get_legend_items_labels_1 = require("../../../state/selectors/get_legend_items_labels");
const dom_1 = require("../renderer/dom");
class MetricState {
    chartType = __1.ChartType.Metric;
    getChartTypeDescription = () => 'Metric chart';
    chartRenderer = () => react_1.default.createElement(dom_1.Metric, null);
    isInitialized = () => get_internal_is_intialized_1.InitStatus.Initialized;
    isBrushAvailable = () => false;
    isBrushing = () => false;
    isChartEmpty = () => false;
    getLegendItems = () => legend_1.EMPTY_LEGEND_LIST;
    getLegendItemsLabels = () => get_legend_items_labels_1.EMPTY_LEGEND_ITEM_LIST;
    getLegendExtraValues = () => legend_1.EMPTY_LEGEND_ITEM_EXTRA_VALUES;
    getPointerCursor = () => constants_1.DEFAULT_CSS_CURSOR;
    isTooltipVisible = () => ({
        visible: false,
        isExternal: false,
        displayOnly: false,
        isPinnable: false,
    });
    getTooltipInfo = () => undefined;
    getTooltipAnchor = () => null;
    eventCallbacks = () => { };
    getProjectionContainerArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
    getMainProjectionArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
    getBrushArea = () => null;
    getDebugState = () => ({});
    getSmallMultiplesDomains() {
        return {
            smHDomain: [],
            smVDomain: [],
        };
    }
    canDisplayChartTitles(globalState) {
        return (0, can_display_chart_titles_1.canDisplayChartTitles)(globalState);
    }
}
exports.MetricState = MetricState;
//# sourceMappingURL=chart_state.js.map