"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgressBar = void 0;
const classnames_1 = __importDefault(require("classnames"));
const d3_scale_1 = require("d3-scale");
const react_1 = __importDefault(require("react"));
const icon_1 = require("../../../../components/icons/icon");
const common_1 = require("../../../../utils/common");
const specs_1 = require("../../specs");
const TARGET_SIZE = 8;
const BASELINE_SIZE = 2;
const ProgressBar = ({ datum, barBackground, blendedBarColor, size, }) => {
    const { title, value, target, valueFormatter, targetFormatter, progressBarDirection } = datum;
    const isBullet = (0, specs_1.isBulletMetric)(datum);
    const isVertical = progressBarDirection === common_1.LayoutDirection.Vertical;
    const domain = (0, specs_1.isBulletMetric)(datum) ? datum.domain : [0, datum.domainMax];
    const scale = (0, d3_scale_1.scaleLinear)().domain(domain).range([0, 100]);
    if ((0, specs_1.isBulletMetric)(datum) && datum.niceDomain) {
        scale.nice();
    }
    const updatedDomain = scale.domain();
    const [domainMin, domainMax] = (0, common_1.sortNumbers)(updatedDomain);
    const scaledValue = scale(value);
    const [min, max] = (0, common_1.sortNumbers)([scale(0), scaledValue]);
    const positionStyle = isVertical
        ? {
            bottom: `${min}%`,
            top: `${100 - max}%`,
        }
        : {
            left: `${min}%`,
            right: `${100 - max}%`,
        };
    const targetPlacement = (0, common_1.isNil)(target) ? null : `calc(${scale(target)}% - ${TARGET_SIZE / 2}px)`;
    const zeroPlacement = domainMin >= 0 || domainMax <= 0 ? null : `calc(${scale(0)}% - ${BASELINE_SIZE / 2}px)`;
    const labelType = isBullet ? 'Value' : 'Percentage';
    return (react_1.default.createElement("div", { className: getDirectionalClasses('Progress', isVertical, size), style: { backgroundColor: size === 'small' ? barBackground : undefined }, title: !isBullet ? '' : `${updatedDomain[0]} to ${updatedDomain[1]}` },
        targetPlacement && (react_1.default.createElement("div", { className: getDirectionalClasses('Target', isVertical, size), style: {
                [isVertical ? 'bottom' : 'left']: targetPlacement,
            }, "aria-valuenow": target, title: `${isBullet ? `${datum.valueLabels.target}: ` : ''}${(targetFormatter ?? valueFormatter)(target || 0)}` },
            react_1.default.createElement(icon_1.Icon, { height: TARGET_SIZE, width: TARGET_SIZE, type: "downArrow", color: blendedBarColor }))),
        zeroPlacement && (react_1.default.createElement("div", { className: getDirectionalClasses('ZeroBaseline', isVertical, size), style: {
                backgroundColor: blendedBarColor,
                [isVertical ? 'bottom' : 'left']: zeroPlacement,
            } })),
        react_1.default.createElement("div", { className: getDirectionalClasses('ProgressBar', isVertical, size), style: { ...positionStyle, backgroundColor: blendedBarColor }, role: "meter", title: isBullet ? `${datum.valueLabels.value}: ${valueFormatter(value)}` : `${scaledValue}%`, "aria-label": title ? `${labelType} of ${title}` : labelType, "aria-valuemin": isBullet ? domainMin : 0, "aria-valuemax": isBullet ? domainMax : 100, "aria-valuenow": isBullet ? value : scaledValue })));
};
exports.ProgressBar = ProgressBar;
function getDirectionalClasses(element, isVertical, size) {
    const base = `echSingleMetric${element}`;
    return (0, classnames_1.default)(base, `${base}--${size}`, {
        [`${base}--vertical`]: isVertical,
        [`${base}--horizontal`]: !isVertical,
    });
}
//# sourceMappingURL=progress.js.map