/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { __awaiter, __generator } from "tslib";
import * as process from 'process';
import { execAsync } from './execAsync';
import { diag } from '@opentelemetry/api';
export function getMachineId() {
    return __awaiter(this, void 0, void 0, function () {
        var args, command, result, parts, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    args = 'QUERY HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography /v MachineGuid';
                    command = '%windir%\\System32\\REG.exe';
                    if (process.arch === 'ia32' && 'PROCESSOR_ARCHITEW6432' in process.env) {
                        command = '%windir%\\sysnative\\cmd.exe /c ' + command;
                    }
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, execAsync(command + " " + args)];
                case 2:
                    result = _a.sent();
                    parts = result.stdout.split('REG_SZ');
                    if (parts.length === 2) {
                        return [2 /*return*/, parts[1].trim()];
                    }
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    diag.debug("error reading machine id: " + e_1);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/, ''];
            }
        });
    });
}
//# sourceMappingURL=getMachineId-win.js.map