/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { __awaiter, __generator } from "tslib";
import { execAsync } from './execAsync';
import { diag } from '@opentelemetry/api';
export function getMachineId() {
    return __awaiter(this, void 0, void 0, function () {
        var result, idLine, parts, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, execAsync('ioreg -rd1 -c "IOPlatformExpertDevice"')];
                case 1:
                    result = _a.sent();
                    idLine = result.stdout
                        .split('\n')
                        .find(function (line) { return line.includes('IOPlatformUUID'); });
                    if (!idLine) {
                        return [2 /*return*/, ''];
                    }
                    parts = idLine.split('" = "');
                    if (parts.length === 2) {
                        return [2 /*return*/, parts[1].slice(0, -1)];
                    }
                    return [3 /*break*/, 3];
                case 2:
                    e_1 = _a.sent();
                    diag.debug("error reading machine id: " + e_1);
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/, ''];
            }
        });
    });
}
//# sourceMappingURL=getMachineId-darwin.js.map