"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchHistoryItem = void 0;
require("moment-duration-format");
var _lodash = require("lodash");
var _get_moment = require("../../../../common/lib/get_moment");
var _watch_status = require("../watch_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WatchHistoryItem {
  constructor(props = {}) {
    this.id = props.id;
    this.watchId = props.watchId;
    this.details = props.details;
    this.startTime = (0, _get_moment.getMoment)(props.startTime);
    this.watchStatus = _watch_status.WatchStatus.fromUpstreamJson((0, _lodash.get)(props, 'watchStatus'));
  }
  static fromUpstreamJson(upstreamHistory) {
    return new WatchHistoryItem(upstreamHistory);
  }
}
exports.WatchHistoryItem = WatchHistoryItem;