"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeNoMatch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let bannerId;
const VisualizeNoMatch = () => {
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    services.restorePreviousUrl();
    const {
      navigated
    } = services.urlForwarding.navigateToLegacyKibanaUrl(services.history.location.pathname + services.history.location.search);
    if (!navigated) {
      const bannerMessage = _i18n.i18n.translate('visualizations.noMatchRoute.bannerTitleText', {
        defaultMessage: 'Page not found'
      });
      bannerId = services.overlays.banners.replace(bannerId, (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
        theme$: services.theme.theme$
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "iInCircle",
        title: bannerMessage
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.noMatchRoute.bannerText",
        defaultMessage: "Visualize application doesn't recognize this route: {route}.",
        values: {
          route: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: window.location.href
          }, services.history.location.pathname)
        }
      }))))));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        services.overlays.banners.remove(bannerId);
      }, 15000);
      services.history.replace(_constants.VisualizeConstants.LANDING_PAGE_PATH);
    }
  }, [services]);
  return null;
};
exports.VisualizeNoMatch = VisualizeNoMatch;