"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeEditorCommon = void 0;
require("./visualize_editor.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _visualize_top_nav = require("./visualize_top_nav");
var _experimental_vis_info = require("./experimental_vis_info");
var _ = require("../..");
var _services = require("../../services");
var _viz_chart_warning = require("./viz_chart_warning");
var _split_chart_warning_helpers = require("../utils/split_chart_warning_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VisualizeEditorCommon = ({
  visInstance,
  appState,
  currentAppState,
  isChromeVisible,
  hasUnsavedChanges,
  setHasUnsavedChanges,
  hasUnappliedChanges,
  isEmbeddableRendered,
  onAppLeave,
  originatingApp,
  originatingPath,
  setOriginatingApp,
  visualizationIdFromUrl,
  embeddableId,
  visEditorRef,
  eventEmitter
}) => {
  var _visInstance$vis2, _visInstance$vis4, _visInstance$vis5, _visInstance$vis5$dat, _visInstance$vis6, _visInstance$vis6$typ, _visInstance$vis7, _visInstance$vis7$typ, _visInstance$vis8, _visInstance$vis8$typ, _visInstance$vis9, _visInstance$vis9$typ, _visInstance$vis9$typ2;
  const {
    services
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    async function aliasMatchRedirect() {
      const sharingSavedObjectProps = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps;
      if (services.spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'aliasMatch') {
        var _visInstance$vis;
        // We found this object by a legacy URL alias from its old ID; redirect the user to the page with its new ID, preserving any URL hash
        const newObjectId = sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'aliasMatch'
        const newPath = `${(0, _.urlFor)(newObjectId)}${services.history.location.search}`;
        await services.spaces.ui.redirectLegacyUrl({
          path: newPath,
          aliasPurpose: sharingSavedObjectProps.aliasPurpose,
          objectNoun: _i18n.i18n.translate('visualizations.legacyUrlConflict.objectNoun', {
            defaultMessage: '{visName} visualization',
            values: {
              visName: visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis = visInstance.vis) === null || _visInstance$vis === void 0 ? void 0 : _visInstance$vis.type.title
            }
          })
        });
        return;
      }
    }
    aliasMatchRedirect();
  }, [visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis2 = visInstance.vis) === null || _visInstance$vis2 === void 0 ? void 0 : _visInstance$vis2.type.title, services]);
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario
    const currentObjectId = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.id;
    const sharingSavedObjectProps = visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis.sharingSavedObjectProps;
    if (services.spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' && currentObjectId) {
      var _visInstance$vis3;
      // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
      // callout with a warning for the user, and provide a way for them to navigate to the other object.
      const otherObjectId = sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'conflict'
      const otherObjectPath = `${(0, _.urlFor)(otherObjectId)}${services.history.location.search}`;
      return services.spaces.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('visualizations.legacyUrlConflict.objectNoun', {
          defaultMessage: '{visName} visualization',
          values: {
            visName: visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis3 = visInstance.vis) === null || _visInstance$vis3 === void 0 ? void 0 : _visInstance$vis3.type.title
          }
        }),
        currentObjectId,
        otherObjectId,
        otherObjectPath
      });
    }
    return null;
  }, [visInstance === null || visInstance === void 0 ? void 0 : visInstance.savedVis, services, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis4 = visInstance.vis) === null || _visInstance$vis4 === void 0 ? void 0 : _visInstance$vis4.type.title]);
  // Adds a notification for split chart on the new implementation as it is not supported yet
  const chartName = visInstance === null || visInstance === void 0 ? void 0 : visInstance.vis.type.name;
  const isSplitChart = (0, _split_chart_warning_helpers.isSplitChart)(chartName, visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis5 = visInstance.vis) === null || _visInstance$vis5 === void 0 ? void 0 : (_visInstance$vis5$dat = _visInstance$vis5.data) === null || _visInstance$vis5$dat === void 0 ? void 0 : _visInstance$vis5$dat.aggs);
  const chartsWithoutSmallMultiples = Object.values(_split_chart_warning_helpers.CHARTS_WITHOUT_SMALL_MULTIPLES);
  const chartNeedsWarning = chartName ? chartsWithoutSmallMultiples.includes(chartName) : false;
  const deprecatedCharts = Object.values(_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED);
  const deprecatedChartsNeedWarning = chartName ? deprecatedCharts.includes(chartName) : false;
  const chartToken = chartName && (chartNeedsWarning || deprecatedChartsNeedWarning) ? _split_chart_warning_helpers.CHARTS_CONFIG_TOKENS[chartName] : undefined;
  const hasLegacyChartsEnabled = chartToken ? (0, _services.getUISettings)().get(chartToken) : true;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `app-container visEditor visEditor--${visInstance === null || visInstance === void 0 ? void 0 : visInstance.vis.type.name}`
  }, visInstance && appState && currentAppState && /*#__PURE__*/_react.default.createElement(_visualize_top_nav.VisualizeTopNav, {
    currentAppState: currentAppState,
    hasUnsavedChanges: hasUnsavedChanges,
    setHasUnsavedChanges: setHasUnsavedChanges,
    isChromeVisible: isChromeVisible,
    isEmbeddableRendered: isEmbeddableRendered,
    hasUnappliedChanges: hasUnappliedChanges,
    originatingApp: originatingApp,
    originatingPath: originatingPath,
    setOriginatingApp: setOriginatingApp,
    visInstance: visInstance,
    stateContainer: appState,
    visualizationIdFromUrl: visualizationIdFromUrl,
    embeddableId: embeddableId,
    onAppLeave: onAppLeave,
    eventEmitter: eventEmitter
  }), (visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis6 = visInstance.vis) === null || _visInstance$vis6 === void 0 ? void 0 : (_visInstance$vis6$typ = _visInstance$vis6.type) === null || _visInstance$vis6$typ === void 0 ? void 0 : _visInstance$vis6$typ.stage) === 'experimental' && !(visInstance !== null && visInstance !== void 0 && (_visInstance$vis7 = visInstance.vis) !== null && _visInstance$vis7 !== void 0 && (_visInstance$vis7$typ = _visInstance$vis7.type) !== null && _visInstance$vis7$typ !== void 0 && _visInstance$vis7$typ.isDeprecated) && /*#__PURE__*/_react.default.createElement(_experimental_vis_info.ExperimentalVisInfo, null), !hasLegacyChartsEnabled && isSplitChart && chartNeedsWarning && chartToken && chartName && /*#__PURE__*/_react.default.createElement(_viz_chart_warning.VizChartWarning, {
    chartType: chartName,
    chartConfigToken: chartToken
  }), (hasLegacyChartsEnabled && deprecatedChartsNeedWarning && chartToken && chartName || (visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis8 = visInstance.vis) === null || _visInstance$vis8 === void 0 ? void 0 : (_visInstance$vis8$typ = _visInstance$vis8.type) === null || _visInstance$vis8$typ === void 0 ? void 0 : _visInstance$vis8$typ.isDeprecated)) && /*#__PURE__*/_react.default.createElement(_viz_chart_warning.VizChartWarning, {
    chartType: chartName,
    chartConfigToken: chartToken !== null && chartToken !== void 0 ? chartToken : undefined,
    mode: "new"
  }), visInstance === null || visInstance === void 0 ? void 0 : (_visInstance$vis9 = visInstance.vis) === null || _visInstance$vis9 === void 0 ? void 0 : (_visInstance$vis9$typ = _visInstance$vis9.type) === null || _visInstance$vis9$typ === void 0 ? void 0 : (_visInstance$vis9$typ2 = _visInstance$vis9$typ.getInfoMessage) === null || _visInstance$vis9$typ2 === void 0 ? void 0 : _visInstance$vis9$typ2.call(_visInstance$vis9$typ, visInstance.vis), getLegacyUrlConflictCallout(), visInstance && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, 'savedVis' in visInstance && visInstance.savedVis.id ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.pageHeading",
    defaultMessage: "{chartName} {chartType} visualization",
    values: {
      chartName: visInstance.savedVis.title,
      chartType: visInstance.vis.type.title
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.byValue_pageHeading",
    defaultMessage: "Visualization of type {chartType} embedded into {originatingApp} app",
    values: {
      chartType: visInstance.vis.type.title,
      originatingApp: originatingApp || 'dashboards'
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: isChromeVisible ? 'visEditor__content' : 'visualize',
    ref: visEditorRef
  }));
};
exports.VisualizeEditorCommon = VisualizeEditorCommon;