"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateBasicSoAttributes = void 0;
var _saved_visualization_references = require("../saved_visualization_references");
var _content_management = require("../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateBasicSoAttributes = async (soId, type, newAttributes, dependencies) => {
  const so = await _content_management.visualizationsClient.get(soId);
  const extractedReferences = (0, _saved_visualization_references.extractReferences)({
    attributes: so.item.attributes,
    references: so.item.references
  });
  let {
    references
  } = extractedReferences;
  const attributes = {
    ...extractedReferences.attributes,
    title: newAttributes.title,
    description: newAttributes.description
  };
  if (dependencies.savedObjectsTagging) {
    references = dependencies.savedObjectsTagging.ui.updateTagsReferences(references, newAttributes.tags || []);
  }
  return await _content_management.visualizationsClient.update({
    id: soId,
    data: {
      ...attributes
    },
    options: {
      overwrite: true,
      references
    }
  });
};
exports.updateBasicSoAttributes = updateBasicSoAttributes;