"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const VisualizationNoResults = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./visualization_noresults'))));
const VisualizationError = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./visualization_error'))));
const VisualizationContainer = ({
  'data-test-subj': dataTestSubj = '',
  className,
  children,
  handlers,
  showNoResult = false,
  error,
  renderComplete
}) => {
  const classes = (0, _classnames.default)('visualization', className);
  const fallBack = /*#__PURE__*/_react.default.createElement("div", {
    className: "visChart__spinner"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    mono: true,
    size: "l"
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    className: classes
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: fallBack
  }, error ? /*#__PURE__*/_react.default.createElement(VisualizationError, {
    onInit: () => handlers.done(),
    error: error
  }) : showNoResult ? /*#__PURE__*/_react.default.createElement(VisualizationNoResults, {
    onInit: () => renderComplete ? renderComplete() : handlers.done()
  }) : children));
};
exports.VisualizationContainer = VisualizationContainer;