"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsBucketContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _tooltip_wrapper = require("../tooltip_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldsBucketContainer = ({
  idx,
  onRemoveClick,
  removeTitle,
  children,
  draggableProvided,
  isNotRemovable,
  isNotDraggable,
  isDragging,
  'data-test-subj': dataTestSubj = 'lns-fieldsBucketContainer'
}) => {
  var _draggableProvided$dr;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    hasShadow: isDragging,
    color: isDragging ? 'plain' : 'transparent',
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
    grow: false
  }, (_draggableProvided$dr = draggableProvided === null || draggableProvided === void 0 ? void 0 : draggableProvided.dragHandleProps) !== null && _draggableProvided$dr !== void 0 ? _draggableProvided$dr : {}), /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('visualizationUiComponents.fieldsBucketContainer.dragHandleDisabled', {
      defaultMessage: 'Reordering requires more than one item.'
    }),
    condition: isNotDraggable !== null && isNotDraggable !== void 0 ? isNotDraggable : true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: euiTheme.colors[isNotDraggable ? 'disabled' : 'text'],
    type: "grab",
    "aria-label": _i18n.i18n.translate('visualizationUiComponents.fieldsBucketContainer.dragToReorder', {
      defaultMessage: 'Drag to reorder'
    }),
    "data-test-subj": `${dataTestSubj}-dragToReorder-${idx}`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      minWidth: 0
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('visualizationUiComponents.fieldsBucketContainer.deleteButtonDisabled', {
      defaultMessage: 'A minimum of one item is required.'
    }),
    condition: isNotRemovable !== null && isNotRemovable !== void 0 ? isNotRemovable : false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": removeTitle,
    onClick: onRemoveClick,
    "data-test-subj": `${dataTestSubj}-removeField-${idx}`,
    isDisabled: isNotRemovable
  })))));
};
exports.FieldsBucketContainer = FieldsBucketContainer;