"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticChartsOptions = ElasticChartsOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _common = require("../../../../../common");
var _services = require("../../../../services");
var _collections = require("../../../collections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const fittingFunctions = (0, _collections.getFittingFunctions)();
function ElasticChartsOptions(props) {
  var _stateParams$fittingF, _stateParams$fillOpac;
  const [palettesRegistry, setPalettesRegistry] = (0, _react.useState)(null);
  const {
    stateParams,
    setValue,
    aggs
  } = props;
  const isLineChart = stateParams.seriesParams.some(({
    type,
    data: {
      id: paramId
    }
  }) => {
    var _aggs$aggs$find;
    return type === _common.ChartType.Line && (aggs === null || aggs === void 0 ? void 0 : (_aggs$aggs$find = aggs.aggs.find(({
      id
    }) => id === paramId)) === null || _aggs$aggs$find === void 0 ? void 0 : _aggs$aggs$find.enabled);
  });
  const isAreaChart = stateParams.seriesParams.some(({
    type,
    data: {
      id: paramId
    }
  }) => {
    var _aggs$aggs$find2;
    return type === _common.ChartType.Area && (aggs === null || aggs === void 0 ? void 0 : (_aggs$aggs$find2 = aggs.aggs.find(({
      id
    }) => id === paramId)) === null || _aggs$aggs$find2 === void 0 ? void 0 : _aggs$aggs$find2.enabled);
  });
  (0, _react.useEffect)(() => {
    const fetchPalettes = async () => {
      const palettes = await (0, _services.getPalettesService)().getPalettes();
      setPalettesRegistry(palettes);
    };
    fetchPalettes();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "detailedTooltip",
    label: _i18n.i18n.translate('visTypeXy.editors.elasticChartsOptions.detailedTooltip.label', {
      defaultMessage: 'Show detailed tooltip'
    }),
    tooltip: _i18n.i18n.translate('visTypeXy.editors.elasticChartsOptions.detailedTooltip.tooltip', {
      defaultMessage: 'Enables the legacy detailed tooltip for displaying a single value. When disabled, a new summarized tooltip will be used to display multiple values.'
    }),
    paramName: "detailedTooltip",
    value: stateParams.detailedTooltip,
    setValue: (paramName, value) => {
      setValue(paramName, value);
    }
  }), (isLineChart || isAreaChart) && /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    "data-test-subj": "fittingFunction",
    label: _i18n.i18n.translate('visTypeXy.editors.elasticChartsOptions.missingValuesLabel', {
      defaultMessage: 'Fill missing values'
    }),
    options: fittingFunctions,
    paramName: "fittingFunction",
    value: (_stateParams$fittingF = stateParams.fittingFunction) !== null && _stateParams$fittingF !== void 0 ? _stateParams$fittingF : fittingFunctions[2].value,
    setValue: (paramName, value) => {
      setValue(paramName, value);
    }
  }), palettesRegistry && /*#__PURE__*/_react.default.createElement(_public.PalettePicker, {
    palettes: palettesRegistry,
    activePalette: stateParams.palette,
    paramName: "palette",
    setPalette: (paramName, value) => {
      setValue(paramName, value);
    }
  }), isAreaChart && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeXy.editors.elasticChartsOptions.fillOpacity', {
      defaultMessage: 'Fill opacity'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    "data-test-subj": "fillColorOpacity",
    value: (_stateParams$fillOpac = stateParams.fillOpacity) !== null && _stateParams$fillOpac !== void 0 ? _stateParams$fillOpac : 0.3,
    min: 0,
    max: 1,
    step: 0.1,
    showInput: true,
    fullWidth: true,
    compressed: true,
    onChange: e => {
      setValue('fillOpacity', Number(e.currentTarget.value));
    }
  })));
}