"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initXAxis = initXAxis;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function initXAxis(chart, table) {
  const {
    format,
    title,
    params,
    accessor
  } = chart.aspects.x[0];
  chart.xAxisOrderedValues = accessor === -1 && 'defaultValue' in params ? [params.defaultValue] : (0, _lodash.uniq)(table.rows.map(r => r[accessor]));
  chart.xAxisFormat = format;
  chart.xAxisLabel = title;
  if ('interval' in params) {
    if ('date' in params) {
      const {
        intervalESUnit,
        intervalESValue
      } = params;
      chart.ordered = {
        interval: _moment.default.duration(intervalESValue, intervalESUnit),
        intervalESUnit,
        intervalESValue
      };
    } else {
      chart.ordered = {
        interval: params.interval
      };
    }
  }
}