"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaVisualization = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("./services");
var _vega_state_restorer = require("./lib/vega_state_restorer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const createVegaVisualization = ({
  core,
  getServiceSettings
}, renderMode) => class VegaVisualization {
  constructor(el, fireEvent) {
    (0, _defineProperty2.default)(this, "dataPlugin", (0, _services.getData)());
    (0, _defineProperty2.default)(this, "vegaView", null);
    (0, _defineProperty2.default)(this, "vegaStateRestorer", (0, _vega_state_restorer.createVegaStateRestorer)({
      isActive: () => {
        var _this$vegaView, _this$vegaView$_parse;
        return Boolean((_this$vegaView = this.vegaView) === null || _this$vegaView === void 0 ? void 0 : (_this$vegaView$_parse = _this$vegaView._parser) === null || _this$vegaView$_parse === void 0 ? void 0 : _this$vegaView$_parse.restoreSignalValuesOnRefresh);
      }
    }));
    this.el = el;
    this.fireEvent = fireEvent;
  }
  async render(visData) {
    const {
      toasts
    } = (0, _services.getNotifications)();
    if (!visData && !this.vegaView) {
      toasts.addWarning(_i18n.i18n.translate('visTypeVega.visualization.unableToRenderWithoutDataWarningMessage', {
        defaultMessage: 'Unable to render without data'
      }));
      return;
    }
    try {
      await this._render(visData);
    } catch (error) {
      if (this.vegaView) {
        this.vegaView.onError(error);
      } else {
        toasts.addError(error, {
          title: _i18n.i18n.translate('visTypeVega.visualization.renderErrorTitle', {
            defaultMessage: 'Vega error'
          })
        });
      }
    }
  }
  async _render(vegaParser) {
    if (vegaParser) {
      var _vegaParser$searchAPI, _this$vegaView2;
      (_vegaParser$searchAPI = vegaParser.searchAPI.inspectorAdapters) === null || _vegaParser$searchAPI === void 0 ? void 0 : _vegaParser$searchAPI.vega.clearError();
      // New data received, rebuild the graph
      if (this.vegaView) {
        await this.vegaView.destroy();
        this.vegaView = null;
      }
      const serviceSettings = await getServiceSettings();
      const {
        filterManager
      } = this.dataPlugin.query;
      const {
        timefilter
      } = this.dataPlugin.query.timefilter;
      const vegaViewParams = {
        externalUrl: core.http.externalUrl,
        parentEl: this.el,
        fireEvent: this.fireEvent,
        vegaStateRestorer: this.vegaStateRestorer,
        vegaParser,
        serviceSettings,
        filterManager,
        timefilter,
        renderMode
      };
      if (vegaParser.useMap) {
        const {
          VegaMapView
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vega_view/vega_map_view/view')));
        this.vegaView = new VegaMapView(vegaViewParams);
      } else {
        const {
          VegaView: VegaViewClass
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vega_view/vega_view')));
        this.vegaView = new VegaViewClass(vegaViewParams);
      }
      await ((_this$vegaView2 = this.vegaView) === null || _this$vegaView2 === void 0 ? void 0 : _this$vegaView2.init());
    }
  }
  async resize(dimensions) {
    var _this$vegaView3;
    return (_this$vegaView3 = this.vegaView) === null || _this$vegaView3 === void 0 ? void 0 : _this$vegaView3.resize(dimensions);
  }
  destroy() {
    var _this$vegaView4;
    this.vegaStateRestorer.clear();
    (_this$vegaView4 = this.vegaView) === null || _this$vegaView4 === void 0 ? void 0 : _this$vegaView4.destroy();
  }
};
exports.createVegaVisualization = createVegaVisualization;