"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaRequestHandler = createVegaRequestHandler;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _search_api = require("./data_model/search_api");
var _time_cache = require("./data_model/time_cache");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function createVegaRequestHandler({
  plugins: {
    data
  },
  core: {
    uiSettings
  },
  getServiceSettings
}, context = {}) {
  let searchAPI;
  const {
    timefilter
  } = data.query.timefilter;
  const timeCache = new _time_cache.TimeCache(timefilter, 3 * 1000);
  return async function vegaRequestHandler({
    timeRange,
    filters,
    query,
    visParams,
    searchSessionId,
    executionContext
  }) {
    var _filters$;
    const {
      search
    } = (0, _services.getData)();
    const dataViews = (0, _services.getDataViews)();
    if (!searchAPI) {
      searchAPI = new _search_api.SearchAPI({
        uiSettings,
        search,
        indexPatterns: dataViews
      }, context.abortSignal, context.inspectorAdapters, searchSessionId, executionContext);
    }
    timeCache.setTimeRange(timeRange);
    let dataView;
    const firstFilterIndex = (_filters$ = filters[0]) === null || _filters$ === void 0 ? void 0 : _filters$.meta.index;
    if (firstFilterIndex) {
      dataView = await dataViews.get(firstFilterIndex).catch(() => undefined);
    }
    const esQueryConfigs = (0, _public.getEsQueryConfig)(uiSettings);
    const filtersDsl = (0, _esQuery.buildEsQuery)(dataView, query, filters, esQueryConfigs);
    const {
      VegaParser
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./data_model/vega_parser')));
    const vp = new VegaParser(visParams.spec, searchAPI, timeCache, filtersDsl, getServiceSettings);
    return await vp.parseAsync();
  };
}