"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const vegaAdapterSignalLabel = _i18n.i18n.translate('visTypeVega.inspector.vegaAdapter.signal', {
  defaultMessage: 'Signal'
});
const vegaAdapterValueLabel = _i18n.i18n.translate('visTypeVega.inspector.vegaAdapter.value', {
  defaultMessage: 'Value'
});

/** Get Runtime Scope for Vega View
 * @link https://vega.github.io/vega/docs/api/debugging/#scope
 **/
const getVegaRuntimeScope = debugValues => {
  var _debugValues$view$_ru;
  const {
    data,
    signals
  } = (_debugValues$view$_ru = debugValues.view._runtime) !== null && _debugValues$view$_ru !== void 0 ? _debugValues$view$_ru : {};
  return {
    data,
    signals
  };
};
const serializeColumns = (item, columns) => {
  const nonSerializableFieldLabel = '(..)';
  return columns.reduce((row, column) => {
    try {
      const cell = item[column];
      row[column] = typeof cell === 'object' ? JSON.stringify(cell) : `${cell}`;
    } catch (e) {
      row[column] = nonSerializableFieldLabel;
    }
    return row;
  }, {});
};
class VegaAdapter {
  constructor() {
    (0, _defineProperty2.default)(this, "debugValuesSubject", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "error", new _rxjs.BehaviorSubject(undefined));
  }
  bindInspectValues(debugValues) {
    this.debugValuesSubject.next(debugValues);
  }
  getDataSetsSubscription() {
    return this.debugValuesSubject.pipe((0, _operators.filter)(debugValues => Boolean(debugValues)), (0, _operators.map)(debugValues => {
      const runtimeScope = getVegaRuntimeScope(debugValues);
      return Object.keys(runtimeScope.data || []).reduce((acc, key) => {
        const {
          value
        } = runtimeScope.data[key].values;
        if (value && value[0]) {
          const columns = Object.keys(value[0]);
          acc.push({
            id: key,
            columns: columns.map(column => ({
              id: column,
              schema: 'json'
            })),
            data: value.map(item => serializeColumns(item, columns))
          });
        }
        return acc;
      }, []);
    }));
  }
  getSignalsSetsSubscription() {
    const signalsListener = this.debugValuesSubject.pipe((0, _operators.filter)(debugValues => Boolean(debugValues)), (0, _operators.switchMap)(debugValues => {
      const runtimeScope = getVegaRuntimeScope(debugValues);
      return (0, _rxjs.merge)(...Object.keys(runtimeScope.signals).map(key => (0, _rxjs.fromEventPattern)(handler => debugValues.view.addSignalListener(key, handler), handler => debugValues.view.removeSignalListener(key, handler)))).pipe((0, _operators.debounce)(val => (0, _rxjs.timer)(350)), (0, _operators.map)(() => debugValues));
    }));
    return (0, _rxjs.merge)(this.debugValuesSubject, signalsListener).pipe((0, _operators.filter)(debugValues => Boolean(debugValues)), (0, _operators.map)(debugValues => {
      const runtimeScope = getVegaRuntimeScope(debugValues);
      return {
        columns: [{
          id: vegaAdapterSignalLabel,
          schema: 'text'
        }, {
          id: vegaAdapterValueLabel,
          schema: 'json'
        }],
        data: Object.keys(runtimeScope.signals).map(key => serializeColumns({
          [vegaAdapterSignalLabel]: key,
          [vegaAdapterValueLabel]: runtimeScope.signals[key].value
        }, [vegaAdapterSignalLabel, vegaAdapterValueLabel]))
      };
    }));
  }
  getSpecSubscription() {
    return this.debugValuesSubject.pipe((0, _operators.filter)(debugValues => Boolean(debugValues)), (0, _operators.map)(debugValues => JSON.stringify(debugValues.spec, null, 2)));
  }
  getErrorObservable() {
    return this.error.asObservable();
  }
  setError(error) {
    this.error.next(error);
  }
  clearError() {
    this.error.next(undefined);
  }
}
exports.VegaAdapter = VegaAdapter;