"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChartType = void 0;
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _enums = require("../../../../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getChartType = (series, type) => {
  let layerChartType = _convert_to_lens.SeriesTypes.LINE;
  switch (series.chart_type) {
    case _convert_to_lens.SeriesTypes.LINE:
      layerChartType = Number(series.fill) > 0 ? _convert_to_lens.SeriesTypes.AREA : _convert_to_lens.SeriesTypes.LINE;
      break;
    case _convert_to_lens.SeriesTypes.AREA:
      layerChartType = _convert_to_lens.SeriesTypes.AREA;
      break;
    case _convert_to_lens.SeriesTypes.BAR:
      layerChartType = _convert_to_lens.SeriesTypes.BAR;
      break;
  }
  if (type === _enums.PANEL_TYPES.TOP_N) {
    return _convert_to_lens.SeriesTypes.BAR_HORIZONTAL;
  }
  if (series.stacked !== 'none' && series.stacked !== 'percent') {
    return layerChartType !== _convert_to_lens.SeriesTypes.LINE ? `${layerChartType}_stacked` : _convert_to_lens.SeriesTypes.LINE;
  }
  if (series.stacked === 'percent') {
    return layerChartType !== _convert_to_lens.SeriesTypes.LINE ? `${layerChartType}_percentage_stacked` : _convert_to_lens.SeriesTypes.LINE;
  }
  return layerChartType;
};
exports.getChartType = getChartType;