"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateItem = exports.swapItems = exports.getGroupedOptions = exports.findInGroupedOptions = exports.deleteItem = exports.addNewItem = exports.MAX_MULTI_FIELDS_ITEMS = exports.INVALID_FIELD_ID = void 0;
var _check_ui_restrictions = require("../../../../../common/check_ui_restrictions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const INVALID_FIELD_ID = 'INVALID_FIELD';
exports.INVALID_FIELD_ID = INVALID_FIELD_ID;
const MAX_MULTI_FIELDS_ITEMS = 4;
exports.MAX_MULTI_FIELDS_ITEMS = MAX_MULTI_FIELDS_ITEMS;
const getGroupedOptions = (type, selectedIds, fields = [], uiRestrictions, restrict = []) => {
  const isFieldTypeEnabled = fieldType => restrict.length ? restrict.includes(fieldType) : true;
  const sortByLabel = (a, b) => {
    const getNormalizedString = option => (option.label || '').toLowerCase();
    return getNormalizedString(a).localeCompare(getNormalizedString(b));
  };
  const groupedOptions = Object.values(fields.reduce((acc, field) => {
    if (isFieldTypeEnabled(field.type) && (0, _check_ui_restrictions.isFieldEnabled)(field.name, type, uiRestrictions)) {
      var _field$label, _acc$field$type;
      const item = {
        value: field.name,
        label: (_field$label = field.label) !== null && _field$label !== void 0 ? _field$label : field.name,
        disabled: selectedIds.includes(field.name)
      };
      const fieldTypeOptions = (_acc$field$type = acc[field.type]) === null || _acc$field$type === void 0 ? void 0 : _acc$field$type.options;
      if (fieldTypeOptions) {
        fieldTypeOptions.push(item);
      } else {
        acc[field.type] = {
          options: [item],
          label: field.type
        };
      }
    }
    return acc;
  }, {}));

  // sort groups
  groupedOptions.sort(sortByLabel);

  // sort items
  groupedOptions.forEach(group => {
    if (Array.isArray(group.options)) {
      group.options.sort(sortByLabel);
    }
  });
  return groupedOptions;
};
exports.getGroupedOptions = getGroupedOptions;
const findInGroupedOptions = (groupedOptions, fieldName) => (groupedOptions || []).map(i => i.options).flat().find(i => (i === null || i === void 0 ? void 0 : i.value) === fieldName);
exports.findInGroupedOptions = findInGroupedOptions;
const updateItem = (existingItems, value = null, index = 0) => {
  const arr = [...existingItems];
  arr[index] = value;
  return arr;
};
exports.updateItem = updateItem;
const addNewItem = (existingItems, insertAfter = 0) => {
  const arr = [...existingItems];
  arr.splice(insertAfter + 1, 0, null);
  return arr;
};
exports.addNewItem = addNewItem;
const deleteItem = (existingItems, index = 0) => existingItems.filter((item, i) => i !== index);
exports.deleteItem = deleteItem;
const swapItems = (existingItems, source = 0, destination = 0) => {
  const arr = [...existingItems];
  arr.splice(destination, 0, arr.splice(source, 1)[0]);
  return arr;
};
exports.swapItems = swapItems;