"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getConfiguration = (layerId, {
  gauge
}, palette, {
  metrics,
  buckets,
  maxAccessor,
  columnsWithoutReferenced,
  bucketCollapseFn
}) => {
  const [metricAccessor] = metrics;
  const [breakdownByAccessor] = buckets.all;
  const collapseFn = bucketCollapseFn ? Object.keys(bucketCollapseFn).find(key => bucketCollapseFn[key].includes(breakdownByAccessor)) : undefined;
  return {
    layerId,
    layerType: 'data',
    palette,
    metricAccessor,
    breakdownByAccessor,
    maxAccessor,
    showBar: Boolean(maxAccessor),
    collapseFn,
    subtitle: gauge.labels.show && gauge.style.subText ? gauge.style.subText : undefined
  };
};
exports.getConfiguration = getConfiguration;