"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LongLegendOptions = LongLegendOptions;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _switch = require("./switch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_TRUNCATE_LINES = 5;
const MIN_TRUNCATE_LINES = 1;
function LongLegendOptions({
  'data-test-subj': dataTestSubj,
  setValue,
  truncateLegend,
  maxLegendLines
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_switch.SwitchOption, {
    "data-test-subj": dataTestSubj,
    label: _i18n.i18n.translate('visDefaultEditor.options.longLegends.truncateLegendTextLabel', {
      defaultMessage: 'Truncate legend text'
    }),
    paramName: "truncateLegend",
    value: truncateLegend,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visDefaultEditor.options.longLegends.maxLegendLinesLabel",
      defaultMessage: "Maximum legend lines"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "timeSeriesEditorDataMaxLegendLines",
    value: maxLegendLines,
    min: MIN_TRUNCATE_LINES,
    max: MAX_TRUNCATE_LINES,
    fullWidth: true,
    disabled: !Boolean(truncateLegend),
    onChange: e => {
      const val = Number(e.target.value);
      setValue('maxLegendLines', Math.min(MAX_TRUNCATE_LINES, Math.max(val, MIN_TRUNCATE_LINES)));
    }
  })));
}