"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpRangesParamEditor = IpRangesParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _from_to_list = require("./components/from_to_list");
var _mask_list = require("./components/mask_list");
var _ip_range_type = require("./ip_range_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function IpRangesParamEditor({
  agg,
  value = {
    fromTo: [],
    mask: []
  },
  setTouched,
  setValue,
  setValidity,
  showValidation
}) {
  const handleMaskListChange = (0, _react.useCallback)(items => setValue({
    ...value,
    [_ip_range_type.IpRangeTypes.MASK]: items
  }), [setValue, value]);
  const handleFromToListChange = (0, _react.useCallback)(items => setValue({
    ...value,
    [_ip_range_type.IpRangeTypes.FROM_TO]: items
  }), [setValue, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    id: `visEditorIpRange${agg.id}`,
    display: "rowCompressed"
  }, agg.params.ipRangeType === _ip_range_type.IpRangeTypes.MASK ? /*#__PURE__*/_react.default.createElement(_mask_list.MaskList, {
    list: value.mask,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleMaskListChange,
    setValidity: setValidity
  }) : /*#__PURE__*/_react.default.createElement(_from_to_list.FromToList, {
    list: value.fromTo,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleFromToListChange,
    setValidity: setValidity
  }));
}