"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_layer_list = require("./use_layer_list");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptionItem = (0, _styledComponents.default)(_eui.EuiDescriptionListDescription)`
  &&& {
    width: 25%;
  }
`;
const TitleItem = (0, _styledComponents.default)(_eui.EuiDescriptionListTitle)`
  &&& {
    width: 75%;
  }
`;
function MapToolTipComponent({
  closeTooltip,
  features = [],
  loadFeatureProperties
}) {
  var _features$;
  const {
    id: featureId,
    layerId,
    mbProperties
  } = (_features$ = features[0]) !== null && _features$ !== void 0 ? _features$ : {};
  const [regionName, setRegionName] = (0, _react.useState)(featureId);
  const [pageLoadDuration, setPageLoadDuration] = (0, _react.useState)('');
  const formatPageLoadValue = val => {
    const valInMs = val / 1000;
    if (valInMs > 1000) {
      return (valInMs / 1000).toFixed(2) + ' sec';
    }
    return (valInMs / 1000).toFixed(0) + ' ms';
  };
  (0, _react.useEffect)(() => {
    const loadRegionInfo = async () => {
      if (loadFeatureProperties) {
        const items = await loadFeatureProperties({
          layerId,
          properties: mbProperties
        });
        items.forEach(item => {
          if (item.getPropertyKey() === _use_layer_list.COUNTRY_NAME || item.getPropertyKey() === _use_layer_list.REGION_NAME) {
            setRegionName(item.getRawValue());
          }
          if (item.getPropertyKey() === _use_layer_list.TRANSACTION_DURATION_REGION || item.getPropertyKey() === _use_layer_list.TRANSACTION_DURATION_COUNTRY) {
            setPageLoadDuration(formatPageLoadValue(+item.getRawValue()));
          }
        });
      }
    };
    loadRegionInfo();
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => {
      if (closeTooltip != null) {
        closeTooltip();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, regionName), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    textStyle: "reverse",
    compressed: true,
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(TitleItem, {
    className: "eui-textNoWrap"
  }, _translations.I18LABELS.avgPageLoadDuration), /*#__PURE__*/_react.default.createElement(DescriptionItem, null, pageLoadDuration))));
}
const MapToolTip = /*#__PURE__*/_react.default.memo(MapToolTipComponent);
exports.MapToolTip = MapToolTip;