"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LevelInfoTip = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  critical: _i18n.i18n.translate('xpack.upgradeAssistant.levelInfoTip.criticalLabel', {
    defaultMessage: 'Critical issues must be resolved before you upgrade'
  }),
  warning: _i18n.i18n.translate('xpack.upgradeAssistant.levelInfoTip.warningLabel', {
    defaultMessage: 'Warning issues can be ignored at your discretion'
  })
};
const LevelInfoTip = ({
  level
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: i18nTexts[level],
    position: "top",
    type: "iInCircle"
  });
};
exports.LevelInfoTip = LevelInfoTip;