"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemIndicesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutCloseButtonLabel', {
    defaultMessage: 'Close'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutTitle', {
    defaultMessage: 'Migrate system indices'
  }),
  flyoutDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutDescription', {
    defaultMessage: 'Migrate the indices that store information for the following features before you upgrade.'
  }),
  migrationCompleteLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migrationCompleteLabel', {
    defaultMessage: 'Migration complete'
  }),
  needsMigrationLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.needsMigrationLabel', {
    defaultMessage: 'Migration required'
  }),
  migratingLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migratingLabel', {
    defaultMessage: 'Migration in progress'
  }),
  errorLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.errorLabel', {
    defaultMessage: 'Migration failed'
  }),
  featureNameTableColumn: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.featureNameTableColumn', {
    defaultMessage: 'Feature'
  }),
  statusTableColumn: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.statusTableColumn', {
    defaultMessage: 'Status'
  })
};
const renderMigrationStatus = status => {
  if (status === 'NO_MIGRATION_NEEDED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "green",
      size: "s",
      "data-test-subj": "featureNoUpgradeNeeded"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.migrationCompleteLabel))));
  }
  if (status === 'MIGRATION_NEEDED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "featureUpgradeNeeded"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.needsMigrationLabel));
  }
  if (status === 'IN_PROGRESS') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "featureInProgress"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.migratingLabel))));
  }
  if (status === 'ERROR') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      "data-test-subj": "featureError"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.errorLabel))));
  }
  return '';
};
const columns = [{
  field: 'feature_name',
  name: i18nTexts.featureNameTableColumn,
  sortable: true,
  truncateText: true,
  render: name => (0, _lodash.startCase)(name)
}, {
  field: 'migration_status',
  name: i18nTexts.statusTableColumn,
  sortable: true,
  render: renderMigrationStatus
}];
const SystemIndicesFlyout = ({
  closeFlyout,
  data
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18nTexts.flyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "flyoutDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.flyoutDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "featuresTable",
    itemId: "feature_name",
    items: data.features,
    columns: columns,
    pagination: true,
    sorting: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18nTexts.closeButtonLabel)))));
};
exports.SystemIndicesFlyout = SystemIndicesFlyout;