"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../common/types");
var _utils = require("../../../../lib/utils");
var _types2 = require("../../../types");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  reindexLoadingStatusText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexLoadingStatusText', {
    defaultMessage: 'Loading status…'
  }),
  reindexInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexInProgressText', {
    defaultMessage: 'Reindexing in progress…'
  }),
  reindexCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexCompleteText', {
    defaultMessage: 'Reindex complete'
  }),
  reindexFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexFailedText', {
    defaultMessage: 'Reindex failed'
  }),
  reindexFetchFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexFetchFailedText', {
    defaultMessage: 'Reindex status not available'
  }),
  reindexCanceledText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexCanceledText', {
    defaultMessage: 'Reindex cancelled'
  }),
  reindexPausedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.reindexPausedText', {
    defaultMessage: 'Reindex paused'
  }),
  resolutionText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.resolutionLabel', {
    defaultMessage: 'Reindex'
  }),
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.reindex.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by reindexing this index. This issue can be resolved automatically.'
  })
};
const ReindexResolutionCell = () => {
  const {
    reindexState
  } = (0, _context.useReindexContext)();
  const hasExistingAliases = reindexState.meta.aliases.length > 0;
  if (reindexState.loadingState === _types2.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18nTexts.reindexLoadingStatusText)));
  }
  switch (reindexState.status) {
    case _types.ReindexStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.reindexInProgressText, ' ', (0, _utils.getReindexProgressLabel)(reindexState.reindexTaskPercComplete, reindexState.lastCompletedStep, hasExistingAliases))));
    case _types.ReindexStatus.completed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        color: "success"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.reindexCompleteText)));
    case _types.ReindexStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.reindexFailedText)));
    case _types.ReindexStatus.fetchFailed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.reindexFetchFailedText)));
    case _types.ReindexStatus.paused:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.reindexPausedText)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.resolutionTooltipLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "indexSettings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18nTexts.resolutionText))));
};
exports.ReindexResolutionCell = ReindexResolutionCell;