"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveQueryForm = SaveQueryForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SaveQueryForm({
  savedQuery,
  savedQueryService,
  onSave,
  onClose,
  showFilterOption = true,
  showTimeFilterOption = true
}) {
  var _savedQuery$attribute, _savedQuery$attribute2, _savedQuery$attribute3;
  const [title, setTitle] = (0, _react.useState)((_savedQuery$attribute = savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.title) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : '');
  const [savedQueries, setSavedQueries] = (0, _react.useState)([]);
  const [shouldIncludeFilters, setShouldIncludeFilters] = (0, _react.useState)(Boolean((_savedQuery$attribute2 = savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.filters) !== null && _savedQuery$attribute2 !== void 0 ? _savedQuery$attribute2 : true));
  // Defaults to false because saved queries are meant to be as portable as possible and loading
  // a saved query with a time filter will override whatever the current value of the global timepicker
  // is. We expect this option to be used rarely and only when the user knows they want this behavior.
  const [shouldIncludeTimefilter, setIncludeTimefilter] = (0, _react.useState)(Boolean((_savedQuery$attribute3 = savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.timefilter) !== null && _savedQuery$attribute3 !== void 0 ? _savedQuery$attribute3 : false));
  const [formErrors, setFormErrors] = (0, _react.useState)([]);
  const titleConflictErrorText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryForm.titleConflictText', {
    defaultMessage: 'Name conflicts with an existing query'
  });
  const titleExistsErrorText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryForm.titleExistsText', {
    defaultMessage: 'Name is required.'
  });
  (0, _react.useEffect)(() => {
    const fetchQueries = async () => {
      const allSavedQueries = await savedQueryService.getAllSavedQueries();
      const sortedAllSavedQueries = (0, _lodash.sortBy)(allSavedQueries, 'attributes.title');
      setSavedQueries(sortedAllSavedQueries);
    };
    fetchQueries();
  }, [savedQueryService]);
  const validate = (0, _react.useCallback)(() => {
    const errors = [];
    if (!!savedQueries.find(existingSavedQuery => !savedQuery && existingSavedQuery.attributes.title === title)) {
      errors.push(titleConflictErrorText);
    }
    if (!title) {
      errors.push(titleExistsErrorText);
    }
    if (!(0, _lodash.isEqual)(errors, formErrors)) {
      setFormErrors(errors);
      return false;
    }
    return !formErrors.length;
  }, [savedQueries, formErrors, title, savedQuery, titleConflictErrorText, titleExistsErrorText]);
  const onClickSave = (0, _react.useCallback)(() => {
    if (validate()) {
      onSave({
        id: savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id,
        title,
        description: '',
        shouldIncludeFilters,
        shouldIncludeTimefilter
      });
      onClose();
    }
  }, [validate, onSave, onClose, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id, title, shouldIncludeFilters, shouldIncludeTimefilter]);
  const onInputChange = (0, _react.useCallback)(event => {
    setFormErrors([]);
    setTitle(event.target.value);
  }, []);
  const autoTrim = (0, _react.useCallback)(() => {
    const trimmedTitle = title.trim();
    if (title.length > trimmedTitle.length) {
      setTitle(trimmedTitle);
    }
  }, [title]);
  const hasErrors = formErrors.length > 0;
  const saveQueryForm = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: hasErrors,
    error: formErrors,
    "data-test-subj": "saveQueryForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryNameLabelText', {
      defaultMessage: 'Name'
    }),
    helpText: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryNameHelpText', {
      defaultMessage: 'Name cannot contain a leading or trailing whitespace and must be unique.'
    }),
    isInvalid: hasErrors,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: !!savedQuery,
    value: title,
    name: "title",
    onChange: onInputChange,
    "data-test-subj": "saveQueryFormTitle",
    isInvalid: hasErrors,
    onBlur: autoTrim,
    compressed: true
  })), showFilterOption && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "shouldIncludeFilters",
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryIncludeFiltersLabelText', {
      defaultMessage: 'Include filters'
    }),
    checked: shouldIncludeFilters,
    onChange: () => {
      setShouldIncludeFilters(!shouldIncludeFilters);
    },
    "data-test-subj": "saveQueryFormIncludeFiltersOption"
  })), showTimeFilterOption && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "shouldIncludeTimefilter",
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryIncludeTimeFilterLabelText', {
      defaultMessage: 'Include time filter'
    }),
    checked: shouldIncludeTimefilter,
    onChange: () => {
      setIncludeTimefilter(!shouldIncludeTimefilter);
    },
    "data-test-subj": "saveQueryFormIncludeTimeFilterOption"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    onClick: onClickSave,
    fill: true,
    "data-test-subj": "savedQueryFormSaveButton",
    disabled: hasErrors
  }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryFormSaveButtonText', {
    defaultMessage: 'Save query'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveQueryForm);
}