"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.default = exports.SharingMetaFields = exports.QueryBarTopRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/text-based-languages/public");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _query_string_input = _interopRequireDefault(require("./query_string_input"));
var _no_data_popover = require("./no_data_popover");
var _shallow_equal = require("../utils/shallow_equal");
var _add_filter_popover = require("./add_filter_popover");
var _dataview_picker = require("../dataview_picker");
var _filter_button_group = require("../filter_bar/filter_button_group/filter_button_group");
require("./query_bar.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getNeedsUpdatingLabel: () => _i18n.i18n.translate('unifiedSearch.queryBarTopRow.submitButton.update', {
    defaultMessage: 'Needs updating'
  }),
  getRefreshQueryLabel: () => _i18n.i18n.translate('unifiedSearch.queryBarTopRow.submitButton.refresh', {
    defaultMessage: 'Refresh query'
  }),
  getRunQueryLabel: () => _i18n.i18n.translate('unifiedSearch.queryBarTopRow.submitButton.run', {
    defaultMessage: 'Run query'
  }),
  getDisabledDatePickerLabel: () => _i18n.i18n.translate('unifiedSearch.queryBarTopRow.datePicker.disabledLabel', {
    defaultMessage: 'All time'
  })
};
exports.strings = strings;
const getWrapperWithTooltip = (children, enableTooltip, query) => {
  if (enableTooltip && query && (0, _esQuery.isOfAggregateQueryType)(query)) {
    const textBasedLanguage = (0, _esQuery.getAggregateQueryMode)(query);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('unifiedSearch.query.queryBar.textBasedNonTimestampWarning', {
        defaultMessage: 'Date range selection for {language} queries requires the presence of an @timestamp field in the dataset.',
        values: {
          language: textBasedLanguage
        }
      })
    }, children);
  } else {
    return children;
  }
};
const SuperDatePicker = /*#__PURE__*/_react.default.memo(_eui.EuiSuperDatePicker);

// @internal

const SharingMetaFields = /*#__PURE__*/_react.default.memo(function SharingMetaFields({
  from,
  to,
  dateFormat
}) {
  function toAbsoluteString(value, roundUp = false) {
    const valueAsMoment = _datemath.default.parse(value, {
      roundUp
    });
    if (!valueAsMoment) {
      return value;
    }
    return valueAsMoment.toISOString();
  }
  try {
    const dateRangePretty = (0, _eui.usePrettyDuration)({
      timeFrom: toAbsoluteString(from),
      timeTo: toAbsoluteString(to),
      quickRanges: [],
      dateFormat
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-shared-timefilter-duration": dateRangePretty,
      "data-test-subj": "dataSharedTimefilterDuration"
    });
  } catch (e) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "dataSharedTimefilterDuration"
    });
  }
});
exports.SharingMetaFields = SharingMetaFields;
const QueryBarTopRow = /*#__PURE__*/_react.default.memo(function QueryBarTopRow(props) {
  var _props$submitButtonSt, _timeHistory$get;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const [isXXLarge, setIsXXLarge] = (0, _react.useState)(false);
  const [codeEditorIsExpanded, setCodeEditorIsExpanded] = (0, _react.useState)(false);
  const submitButtonStyle = (_props$submitButtonSt = props.submitButtonStyle) !== null && _props$submitButtonSt !== void 0 ? _props$submitButtonSt : 'auto';
  const submitButtonIconOnly = submitButtonStyle === 'auto' ? !isXXLarge : submitButtonStyle === 'iconOnly';
  (0, _react.useEffect)(() => {
    if (submitButtonStyle !== 'auto') return;
    const handleResize = (0, _lodash.throttle)(() => {
      setIsXXLarge(window.innerWidth >= 1440);
    }, 50);
    window.addEventListener('resize', handleResize);
    handleResize();
    return () => window.removeEventListener('resize', handleResize);
  }, [submitButtonStyle]);
  const {
    showQueryInput = true,
    showDatePicker = true,
    showAutoRefreshOnly = false,
    showSubmitButton = true
  } = props;
  const [isDateRangeInvalid, setIsDateRangeInvalid] = (0, _react.useState)(false);
  const [isQueryInputFocused, setIsQueryInputFocused] = (0, _react.useState)(false);
  const kibana = (0, _public3.useKibana)();
  const {
    uiSettings,
    storage,
    appName,
    data,
    usageCollection,
    unifiedSearch,
    notifications,
    docLinks,
    http,
    dataViews
  } = kibana.services;
  const isQueryLangSelected = props.query && !(0, _esQuery.isOfQueryType)(props.query);
  const queryLanguage = props.query && (0, _esQuery.isOfQueryType)(props.query) && props.query.language;
  const queryRef = (0, _react.useRef)(props.query);
  queryRef.current = props.query;
  const persistedLog = _react.default.useMemo(() => queryLanguage && uiSettings && storage && appName ? (0, _public2.getQueryLog)(uiSettings, storage, appName, queryLanguage) : undefined, [appName, queryLanguage, uiSettings, storage]);
  function getDateRange() {
    const defaultTimeSetting = uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
    return {
      from: props.dateRangeFrom || defaultTimeSetting.from,
      to: props.dateRangeTo || defaultTimeSetting.to
    };
  }
  const currentDateRange = getDateRange();
  const dateRangeRef = (0, _react.useRef)(currentDateRange);
  dateRangeRef.current = currentDateRange;
  const propsOnSubmit = props.onSubmit;
  const toRecentlyUsedRanges = ranges => ranges.map(({
    from,
    to
  }) => {
    return {
      start: from,
      end: to
    };
  });
  const timeHistory = props.timeHistory;
  const timeHistory$ = (0, _react.useMemo)(() => {
    var _timeHistory$get$$pip;
    return (_timeHistory$get$$pip = timeHistory === null || timeHistory === void 0 ? void 0 : timeHistory.get$().pipe((0, _operators.map)(toRecentlyUsedRanges))) !== null && _timeHistory$get$$pip !== void 0 ? _timeHistory$get$$pip : _rxjs.EMPTY;
  }, [timeHistory]);
  const recentlyUsedRanges = (0, _useObservable.default)(timeHistory$, toRecentlyUsedRanges((_timeHistory$get = timeHistory === null || timeHistory === void 0 ? void 0 : timeHistory.get()) !== null && _timeHistory$get !== void 0 ? _timeHistory$get : []));
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get$map, _uiSettings$get;
    return (_uiSettings$get$map = uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES)) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    })) !== null && _uiSettings$get$map !== void 0 ? _uiSettings$get$map : [];
  });
  const onSubmit = (0, _react.useCallback)(({
    query,
    dateRange
  }) => {
    if (timeHistory) {
      timeHistory.add(dateRange);
    }
    propsOnSubmit({
      query,
      dateRange
    });
  }, [timeHistory, propsOnSubmit]);
  const onClickSubmitButton = (0, _react.useCallback)(event => {
    if (persistedLog && queryRef.current && (0, _esQuery.isOfQueryType)(queryRef.current)) {
      persistedLog.add(queryRef.current.query);
    }
    event.preventDefault();
    onSubmit({
      query: queryRef.current,
      dateRange: dateRangeRef.current
    });
  }, [persistedLog, onSubmit]);
  const propsOnChange = props.onChange;
  const onQueryChange = (0, _react.useCallback)(query => {
    return propsOnChange({
      query,
      dateRange: dateRangeRef.current
    });
  }, [propsOnChange]);
  const onChangeQueryInputFocus = (0, _react.useCallback)(isFocused => {
    setIsQueryInputFocused(isFocused);
  }, []);
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid,
    isQuickSelection
  }) => {
    setIsDateRangeInvalid(isInvalid);
    const retVal = {
      query: queryRef.current,
      dateRange: {
        from: start,
        to: end
      }
    };
    if (isQuickSelection) {
      onSubmit(retVal);
    } else {
      propsOnChange(retVal);
    }
  }, [propsOnChange, onSubmit]);
  const propsOnRefresh = props.onRefresh;
  const onRefresh = (0, _react.useCallback)(({
    start,
    end
  }) => {
    const retVal = {
      dateRange: {
        from: start,
        to: end
      }
    };
    if (propsOnRefresh) {
      propsOnRefresh(retVal);
    }
  }, [propsOnRefresh]);
  const onInputSubmit = (0, _react.useCallback)(query => {
    onSubmit({
      query,
      dateRange: dateRangeRef.current
    });
  }, [onSubmit]);
  function shouldRenderQueryInput() {
    return Boolean(showQueryInput && props.query && storage);
  }
  function shouldRenderDatePicker() {
    return Boolean(showDatePicker || showAutoRefreshOnly);
  }
  function renderFilterMenuOnly() {
    return !Boolean(props.showAddFilter) && Boolean(props.prepend);
  }
  function shouldRenderUpdatebutton() {
    return Boolean(showSubmitButton) && Boolean(showQueryInput || showDatePicker || showAutoRefreshOnly);
  }
  function shouldShowDatePickerAsBadge() {
    return Boolean(props.showDatePickerAsBadge) && !shouldRenderQueryInput();
  }
  function renderDatePicker() {
    if (!shouldRenderDatePicker()) {
      return null;
    }
    let isDisabled = Boolean(props.isDisabled);
    let enableTooltip = false;
    // On text based mode the datepicker is always on when the user has unsaved changes.
    // When the user doesn't have any changes it should be disabled if dataview doesn't have @timestamp field
    if (Boolean(isQueryLangSelected) && !props.isDirty) {
      var _props$indexPatterns;
      const adHocDataview = (_props$indexPatterns = props.indexPatterns) === null || _props$indexPatterns === void 0 ? void 0 : _props$indexPatterns[0];
      if (adHocDataview && typeof adHocDataview !== 'string') {
        if (!adHocDataview.timeFieldName) {
          isDisabled = {
            display: /*#__PURE__*/_react.default.createElement("span", {
              "data-test-subj": "kbnQueryBar-datePicker-disabled"
            }, strings.getDisabledDatePickerLabel())
          };
        }
        enableTooltip = !Boolean(adHocDataview.timeFieldName);
      }
    }
    const wrapperClasses = (0, _classnames.default)('kbnQueryBar__datePickerWrapper');
    const datePicker = /*#__PURE__*/_react.default.createElement(SuperDatePicker, {
      isDisabled: isDisabled,
      start: props.dateRangeFrom,
      end: props.dateRangeTo,
      isPaused: props.isRefreshPaused,
      refreshInterval: props.refreshInterval,
      onTimeChange: onTimeChange,
      onRefresh: onRefresh,
      onRefreshChange: props.onRefreshChange,
      showUpdateButton: false,
      recentlyUsedRanges: recentlyUsedRanges,
      locale: _i18n.i18n.getLocale(),
      commonlyUsedRanges: commonlyUsedRanges,
      dateFormat: uiSettings.get('dateFormat'),
      isAutoRefreshOnly: showAutoRefreshOnly,
      className: "kbnQueryBar__datePicker",
      isQuickSelectOnly: isMobile ? false : isQueryInputFocused,
      width: isMobile ? 'full' : 'auto',
      compressed: shouldShowDatePickerAsBadge()
    });
    const component = getWrapperWithTooltip(datePicker, enableTooltip, props.query);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: wrapperClasses
    }, component);
  }
  function renderUpdateButton() {
    if (!shouldRenderUpdatebutton() && !shouldRenderDatePicker()) {
      return null;
    }
    const buttonLabelUpdate = strings.getNeedsUpdatingLabel();
    const buttonLabelRefresh = strings.getRefreshQueryLabel();
    const buttonLabelRun = strings.getRunQueryLabel();
    const iconDirty = Boolean(isQueryLangSelected) ? 'play' : 'kqlFunction';
    const tooltipDirty = Boolean(isQueryLangSelected) ? buttonLabelRun : buttonLabelUpdate;
    const button = props.customSubmitButton ? /*#__PURE__*/_react.default.cloneElement(props.customSubmitButton, {
      onClick: onClickSubmitButton
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
      iconType: props.isDirty ? iconDirty : 'refresh',
      iconOnly: submitButtonIconOnly,
      "aria-label": props.isLoading ? buttonLabelUpdate : buttonLabelRefresh,
      isDisabled: isDateRangeInvalid || props.isDisabled,
      isLoading: props.isLoading,
      onClick: onClickSubmitButton,
      size: shouldShowDatePickerAsBadge() ? 's' : 'm',
      color: props.isDirty ? 'success' : 'primary',
      fill: props.isDirty,
      needsUpdate: props.isDirty,
      "data-test-subj": "querySubmitButton"
      // @ts-expect-error Need to fix expecting `children` in EUI
      ,
      toolTipProps: {
        content: props.isDirty ? tooltipDirty : buttonLabelRefresh,
        delay: 'long',
        position: 'bottom'
      }
    }));

    // allows to render the button without the datepicker
    if (!shouldRenderDatePicker() && shouldRenderUpdatebutton()) {
      return button;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_no_data_popover.NoDataPopover, {
      storage: storage,
      showNoDataPopover: props.indicateNoData
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s"
    }, shouldRenderDatePicker() ? renderDatePicker() : null, shouldRenderUpdatebutton() ? button : null)));
  }
  function renderDataViewsPicker() {
    if (!props.dataViewPickerComponentProps) return;
    let textBasedLanguage;
    if (Boolean(isQueryLangSelected)) {
      const query = props.query;
      textBasedLanguage = (0, _esQuery.getAggregateQueryMode)(query);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        maxWidth: '100%'
      },
      grow: isMobile
    }, /*#__PURE__*/_react.default.createElement(_dataview_picker.DataViewPicker, (0, _extends2.default)({}, props.dataViewPickerComponentProps, {
      trigger: {
        fullWidth: isMobile,
        ...props.dataViewPickerComponentProps.trigger
      },
      onTextLangQuerySubmit: props.onTextLangQuerySubmit,
      textBasedLanguage: textBasedLanguage,
      onSaveTextLanguageQuery: props.onTextBasedSavedAndExit,
      isDisabled: props.isDisabled
    })));
  }
  function renderAddButton() {
    return Boolean(props.showAddFilter) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_filter_popover.AddFilterPopover, {
      indexPatterns: props.indexPatterns,
      filters: props.filters,
      timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: props.filtersForSuggestions,
      onFiltersUpdated: props.onFiltersUpdated,
      buttonProps: {
        size: shouldShowDatePickerAsBadge() ? 's' : 'm',
        display: 'empty'
      },
      isDisabled: props.isDisabled
    }));
  }
  function renderFilterButtonGroup() {
    return (Boolean(props.showAddFilter) || Boolean(props.prepend)) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_filter_button_group.FilterButtonGroup, {
      items: [props.prepend, renderAddButton()],
      attached: renderFilterMenuOnly(),
      size: shouldShowDatePickerAsBadge() ? 's' : 'm'
    }));
  }
  function renderQueryInput() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false
    }, !renderFilterMenuOnly() && renderFilterButtonGroup(), shouldRenderQueryInput() && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "unifiedQueryInput"
    }, /*#__PURE__*/_react.default.createElement(_query_string_input.default, {
      disableAutoFocus: props.disableAutoFocus,
      indexPatterns: props.indexPatterns,
      query: props.query,
      screenTitle: props.screenTitle,
      onChange: onQueryChange,
      onChangeQueryInputFocus: onChangeQueryInputFocus,
      onSubmit: onInputSubmit,
      persistedLog: persistedLog,
      dataTestSubj: props.dataTestSubj,
      placeholder: props.placeholder,
      isClearable: props.isClearable,
      iconType: props.iconType,
      nonKqlMode: props.nonKqlMode,
      timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: props.filtersForSuggestions,
      disableLanguageSwitcher: true,
      prepend: renderFilterMenuOnly() && renderFilterButtonGroup(),
      size: props.suggestionsSize,
      isDisabled: props.isDisabled,
      appName: appName,
      submitOnBlur: props.submitOnBlur,
      deps: {
        unifiedSearch,
        data,
        storage,
        usageCollection,
        notifications,
        docLinks,
        http,
        uiSettings,
        dataViews
      }
    })));
  }
  function renderTextLangEditor() {
    var _props$indexPatterns2;
    const adHocDataview = (_props$indexPatterns2 = props.indexPatterns) === null || _props$indexPatterns2 === void 0 ? void 0 : _props$indexPatterns2[0];
    let detectTimestamp = false;
    if (adHocDataview && typeof adHocDataview !== 'string') {
      detectTimestamp = Boolean(adHocDataview === null || adHocDataview === void 0 ? void 0 : adHocDataview.timeFieldName);
    }
    return isQueryLangSelected && props.query && (0, _esQuery.isOfAggregateQueryType)(props.query) && /*#__PURE__*/_react.default.createElement(_public.TextBasedLangEditor, {
      query: props.query,
      onTextLangQueryChange: props.onTextLangQueryChange,
      expandCodeEditor: status => setCodeEditorIsExpanded(status),
      isCodeEditorExpanded: codeEditorIsExpanded,
      errors: props.textBasedLanguageModeErrors,
      detectTimestamp: detectTimestamp,
      onTextLangQuerySubmit: () => onSubmit({
        query: queryRef.current,
        dateRange: dateRangeRef.current
      }),
      isDisabled: props.isDisabled,
      "data-test-subj": "unifiedTextLangEditor"
    });
  }
  const isScreenshotMode = props.isScreenshotMode === true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SharingMetaFields, {
    from: currentDateRange.from,
    to: currentDateRange.to,
    dateFormat: uiSettings.get('dateFormat')
  }), !isScreenshotMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "kbnQueryBar",
    direction: isMobile && !shouldShowDatePickerAsBadge() ? 'column' : 'row',
    responsive: false,
    gutterSize: "s",
    justifyContent: shouldShowDatePickerAsBadge() ? 'flexStart' : 'flexEnd',
    wrap: true
  }, props.dataViewPickerOverride || renderDataViewsPicker(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: !shouldShowDatePickerAsBadge(),
    style: {
      minWidth: shouldShowDatePickerAsBadge() ? 'auto' : 320,
      maxWidth: '100%'
    }
  }, !isQueryLangSelected ? renderQueryInput() : !codeEditorIsExpanded ? renderTextLangEditor() : null), shouldShowDatePickerAsBadge() && props.filterBar, renderUpdateButton()), !shouldShowDatePickerAsBadge() && props.filterBar, codeEditorIsExpanded && renderTextLangEditor()));
}, ({
  query: prevQuery,
  ...prevProps
}, {
  query: nextQuery,
  ...nextProps
}) => {
  let isQueryEqual = true;
  if (prevQuery !== nextQuery) {
    if (!(0, _fastDeepEqual.default)(prevQuery, nextQuery)) {
      isQueryEqual = false;
    }
  }
  return isQueryEqual && (0, _shallow_equal.shallowEqual)(prevProps, nextProps);
});

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.QueryBarTopRow = QueryBarTopRow;
var _default = QueryBarTopRow;
exports.default = _default;