"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.AddFilterPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_editor_wrapper = require("./filter_editor_wrapper");
var _add_filter_popover = require("./add_filter_popover.styles");
var _filter_editor = require("../filter_bar/filter_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getAddFilterButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterBar.addFilterButtonLabel', {
    defaultMessage: 'Add filter'
  })
};
exports.strings = strings;
const AddFilterPopoverComponent = /*#__PURE__*/_react.default.memo(function AddFilterPopover({
  indexPatterns,
  filters,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  onFiltersUpdated,
  buttonProps,
  isDisabled,
  onCloseFilterPopover,
  onLocalFilterUpdate,
  onLocalFilterCreate
}) {
  const euiTheme = (0, _eui.useEuiTheme)();
  const [showAddFilterPopover, setShowAddFilterPopover] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: strings.getAddFilterButtonLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: "plusInCircleFilled",
    "aria-label": strings.getAddFilterButtonLabel(),
    "data-test-subj": "addFilter",
    onClick: () => setShowAddFilterPopover(isOpen => !isOpen),
    size: "m",
    disabled: isDisabled
  }, buttonProps, {
    style: {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0
    }
  })));
  const closePopover = (0, _react.useCallback)(() => {
    onCloseFilterPopover([() => setShowAddFilterPopover(false)]);
  }, [onCloseFilterPopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addFilterPopover",
    button: button,
    isOpen: showAddFilterPopover,
    closePopover: closePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    panelProps: {
      'data-test-subj': 'addFilterPopover',
      css: (0, _add_filter_popover.popoverDragAndDropCss)(euiTheme)
    },
    initialFocus: ".filterEditor__hiddenItem",
    ownFocus: true,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_filter_editor_wrapper.FilterEditorWrapper, {
    indexPatterns: indexPatterns,
    filters: filters,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions,
    onFiltersUpdated: onFiltersUpdated,
    onLocalFilterUpdate: onLocalFilterUpdate,
    onLocalFilterCreate: onLocalFilterCreate,
    closePopoverOnAdd: () => {
      setShowAddFilterPopover(false);
    },
    closePopoverOnCancel: () => {
      setShowAddFilterPopover(false);
    }
  })));
});
const AddFilterPopover = (0, _filter_editor.withCloseFilterEditorConfirmModal)(AddFilterPopoverComponent);
exports.AddFilterPopover = AddFilterPopover;