"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OperatorInput = OperatorInput;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _filter_editor = require("../../filter_bar/filter_editor");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getOperatorSelectPlaceholderSelectLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.operatorSelectPlaceholderSelect', {
    defaultMessage: 'Select operator'
  })
};
exports.strings = strings;
function OperatorInput({
  field,
  operator,
  params,
  onHandleOperator
}) {
  const {
    disabled
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const operators = field ? (0, _filter_editor.getOperatorOptions)(field) : [];
  const onOperatorChange = (0, _react.useCallback)(([selectedOperator]) => {
    const selectedParams = selectedOperator === operator ? params : undefined;
    onHandleOperator(selectedOperator, selectedParams);
  }, [onHandleOperator, operator, params]);
  return /*#__PURE__*/_react.default.createElement(_filter_editor.GenericComboBox, {
    fullWidth: true,
    compressed: true,
    isDisabled: !field || disabled,
    placeholder: strings.getOperatorSelectPlaceholderSelectLabel(),
    "aria-label": strings.getOperatorSelectPlaceholderSelectLabel(),
    options: operators,
    selectedOptions: operator ? [operator] : [],
    getLabel: ({
      message
    }) => message,
    onChange: onOperatorChange,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    "data-test-subj": "filterOperatorList"
  });
}