"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFromFilter = getFieldFromFilter;
exports.getFilterableFields = getFilterableFields;
exports.getOperatorFromFilter = getOperatorFromFilter;
exports.getOperatorOptions = getOperatorOptions;
exports.isFilterValid = isFilterValid;
exports.validateParams = validateParams;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _fieldTypes = require("@kbn/field-types");
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _common = require("@kbn/data-plugin/common");
var _filter_operators = require("./filter_operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFieldFromFilter(filter, indexPattern) {
  return indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fields.find(field => field.name === filter.meta.key);
}
function getOperatorFromFilter(filter) {
  return _filter_operators.FILTER_OPERATORS.find(operator => {
    return filter.meta.type === operator.type && filter.meta.negate === operator.negate;
  });
}
function getFilterableFields(indexPattern) {
  return indexPattern.fields.filter(_common.isFilterable);
}
function getOperatorOptions(field) {
  return _filter_operators.FILTER_OPERATORS.filter(operator => {
    if (operator.field) return operator.field(field);
    if (operator.fieldTypes) return operator.fieldTypes.includes(field.type);
    return true;
  });
}
function validateParams(params, field) {
  var _field$esTypes;
  switch (field === null || field === void 0 ? void 0 : field.type) {
    case 'date':
      const moment = typeof params === 'string' ? _datemath.default.parse(params) : null;
      return Boolean(typeof params === 'string' && moment && moment.isValid());
    case 'ip':
      try {
        return Boolean(new _common.IpAddress(params));
      } catch (e) {
        return false;
      }
    case 'string':
      if ((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.includes(_fieldTypes.ES_FIELD_TYPES.VERSION)) {
        return (0, _valid.default)(params);
      }
      return true;
    case 'boolean':
      return typeof params === 'boolean';
    default:
      return true;
  }
}
function isFilterValid(indexPattern, field, operator, params) {
  if (!indexPattern || !field || !operator) {
    return false;
  }
  switch (operator.type) {
    case 'phrase':
      return validateParams(params, field);
    case 'phrases':
      if (!Array.isArray(params) || !params.length) {
        return false;
      }
      return params.every(phrase => validateParams(phrase, field));
    case 'range':
      if (typeof params !== 'object') {
        return false;
      }
      return (!params.from || validateParams(params.from, field)) && (!params.to || validateParams(params.to, field));
    case 'exists':
      return true;
    default:
      throw new Error(`Unknown operator type: ${operator.type}`);
  }
}