"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelsFixed = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PanelsFixed = ({
  className,
  hideTopPanel,
  topPanel,
  mainPanel
}) => {
  // By default a flex item has overflow: visible, min-height: auto, and min-width: auto.
  // This can cause the item to overflow the flexbox parent when its content is too large.
  // Setting the overflow to something other than visible (e.g. auto) resets the min-height
  // and min-width to 0 and makes the item respect the flexbox parent's size.
  // https://stackoverflow.com/questions/36247140/why-dont-flex-items-shrink-past-content-size
  const mainPanelCss = (0, _react.css)`
    overflow: auto;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    className: className,
    direction: "column",
    alignItems: "stretch",
    gutterSize: "none",
    responsive: false
  }, !hideTopPanel && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, topPanel), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: mainPanelCss
  }, mainPanel));
};
exports.PanelsFixed = PanelsFixed;