"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panels = exports.PANELS_MODE = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _panels_resizable = require("./panels_resizable");
var _panels_fixed = require("./panels_fixed");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let PANELS_MODE;
exports.PANELS_MODE = PANELS_MODE;
(function (PANELS_MODE) {
  PANELS_MODE["SINGLE"] = "single";
  PANELS_MODE["FIXED"] = "fixed";
  PANELS_MODE["RESIZABLE"] = "resizable";
})(PANELS_MODE || (exports.PANELS_MODE = PANELS_MODE = {}));
const fixedModes = [PANELS_MODE.SINGLE, PANELS_MODE.FIXED];
const Panels = ({
  className,
  mode,
  resizeRef,
  topPanelHeight,
  minTopPanelHeight,
  minMainPanelHeight,
  topPanel,
  mainPanel,
  onTopPanelHeightChange
}) => {
  const panelsProps = {
    className,
    topPanel,
    mainPanel
  };
  return fixedModes.includes(mode) ? /*#__PURE__*/_react.default.createElement(_panels_fixed.PanelsFixed, (0, _extends2.default)({
    hideTopPanel: mode === PANELS_MODE.SINGLE
  }, panelsProps)) : /*#__PURE__*/_react.default.createElement(_panels_resizable.PanelsResizable, (0, _extends2.default)({
    resizeRef: resizeRef,
    topPanelHeight: topPanelHeight,
    minTopPanelHeight: minTopPanelHeight,
    minMainPanelHeight: minMainPanelHeight,
    onTopPanelHeightChange: onTopPanelHeightChange
  }, panelsProps));
};
exports.Panels = Panels;