"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldIconType = getFieldIconType;
var _get_field_type = require("./get_field_type");
var _field_types = require("./field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns an icon type for a field
 * @param field
 * @param getCustomFieldType
 * @public
 */
function getFieldIconType(field, getCustomFieldType) {
  var _field$esTypes;
  const type = getCustomFieldType ? getCustomFieldType(field) : (0, _get_field_type.getFieldType)(field);
  const esType = ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes[0]) || null;
  if (esType && ['_id', '_index'].includes(esType) && type === 'string') {
    return 'keyword';
  }
  if (type === 'unknown' && esType && (0, _field_types.isKnownFieldType)(esType)) {
    return esType;
  }
  return type === 'string' && esType ? esType : type;
}