"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExistingFieldsReader = exports.useExistingFieldsFetcher = exports.resetExistingFieldsCache = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _field_existing = require("../services/field_existing");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getBuildEsQueryAsync = async () => (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')))).buildEsQuery;
const generateId = (0, _eui.htmlIdGenerator)();
const initialData = {};
const unknownInfo = {
  fetchStatus: _types.ExistenceFetchStatus.unknown,
  existingFieldsByFieldNameMap: {},
  numberOfFetches: 0
};
const globalMap$ = new _rxjs.BehaviorSubject(initialData); // for syncing between hooks
let lastFetchId = ''; // persist last fetch id to skip older requests/responses if any

/**
 * Fetches info whether a field contains data or it's empty.
 * Can be used in combination with `useQuerySubscriber` hook for gathering the required params.
 * @param params
 * @public
 */
const useExistingFieldsFetcher = params => {
  const mountedRef = (0, _react.useRef)(true);
  const [activeRequests, setActiveRequests] = (0, _react.useState)(0);
  const isProcessing = activeRequests > 0;
  const fetchFieldsExistenceInfo = (0, _react.useCallback)(async ({
    dataViewId,
    query,
    filters,
    fromDate,
    toDate,
    services: {
      dataViews,
      data,
      core
    },
    onNoData,
    fetchId
  }) => {
    var _globalMap$$getValue, _currentInfo$numberOf, _dataView, _dataView$getAggregat, _dataView2;
    if (!dataViewId || !query || !fromDate || !toDate) {
      return;
    }
    const currentInfo = (_globalMap$$getValue = globalMap$.getValue()) === null || _globalMap$$getValue === void 0 ? void 0 : _globalMap$$getValue[dataViewId];
    if (!mountedRef.current) {
      return;
    }
    const numberOfFetches = ((_currentInfo$numberOf = currentInfo === null || currentInfo === void 0 ? void 0 : currentInfo.numberOfFetches) !== null && _currentInfo$numberOf !== void 0 ? _currentInfo$numberOf : 0) + 1;
    let dataView = null;
    try {
      dataView = await dataViews.get(dataViewId, false);
    } catch (e) {
      //
    }
    if (!((_dataView = dataView) !== null && _dataView !== void 0 && _dataView.title)) {
      return;
    }
    setActiveRequests(value => value + 1);
    const hasRestrictions = Boolean((_dataView$getAggregat = (_dataView2 = dataView).getAggregationRestrictions) === null || _dataView$getAggregat === void 0 ? void 0 : _dataView$getAggregat.call(_dataView2));
    const info = {
      ...unknownInfo,
      numberOfFetches
    };
    if (hasRestrictions) {
      info.fetchStatus = _types.ExistenceFetchStatus.succeeded;
      info.hasDataViewRestrictions = true;
    } else {
      try {
        const result = await (0, _field_existing.loadFieldExisting)({
          dslQuery: await buildSafeEsQuery(dataView, query, filters || [], (0, _public.getEsQueryConfig)(core.uiSettings)),
          fromDate,
          toDate,
          timeFieldName: dataView.timeFieldName,
          data,
          uiSettingsClient: core.uiSettings,
          dataViewsService: dataViews,
          dataView
        });
        const existingFieldNames = (result === null || result === void 0 ? void 0 : result.existingFieldNames) || [];
        if (onNoData && numberOfFetches === 1 && !existingFieldNames.filter(fieldName => {
          var _dataView3, _dataView3$metaFields;
          return !((_dataView3 = dataView) !== null && _dataView3 !== void 0 && (_dataView3$metaFields = _dataView3.metaFields) !== null && _dataView3$metaFields !== void 0 && _dataView3$metaFields.includes(fieldName));
        }).length) {
          onNoData(dataViewId);
        }
        info.existingFieldsByFieldNameMap = booleanMap(existingFieldNames);
        info.fetchStatus = _types.ExistenceFetchStatus.succeeded;
      } catch (error) {
        info.fetchStatus = _types.ExistenceFetchStatus.failed;
      }
    }

    // skip redundant and older results
    if (mountedRef.current && fetchId === lastFetchId) {
      globalMap$.next({
        ...globalMap$.getValue(),
        [dataViewId]: info
      });
    }
    setActiveRequests(value => value - 1);
  }, [mountedRef, setActiveRequests]);
  const dataViewsHash = getDataViewsHash(params.dataViews);
  const refetchFieldsExistenceInfo = (0, _react.useCallback)(async dataViewId => {
    const fetchId = generateId();
    lastFetchId = fetchId;
    const options = {
      fetchId,
      dataViewId,
      ...params
    };
    // refetch only for the specified data view
    if (dataViewId) {
      await fetchFieldsExistenceInfo({
        ...options,
        dataViewId
      });
      return;
    }
    // refetch for all mentioned data views
    await Promise.all(params.dataViews.map(dataView => fetchFieldsExistenceInfo({
      ...options,
      dataViewId: dataView.id
    })));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [fetchFieldsExistenceInfo, dataViewsHash, params.query, params.filters, params.fromDate, params.toDate]);
  (0, _react.useEffect)(() => {
    if (!params.disableAutoFetching) {
      refetchFieldsExistenceInfo();
    }
  }, [refetchFieldsExistenceInfo, params.disableAutoFetching]);
  (0, _react.useEffect)(() => {
    return () => {
      mountedRef.current = false;
      globalMap$.next({}); // reset the cache (readers will continue using their own data slice until they are unmounted too)
    };
  }, [mountedRef]);
  return (0, _react.useMemo)(() => ({
    refetchFieldsExistenceInfo,
    isProcessing
  }), [refetchFieldsExistenceInfo, isProcessing]);
};
exports.useExistingFieldsFetcher = useExistingFieldsFetcher;
const useExistingFieldsReader = () => {
  const mountedRef = (0, _react.useRef)(true);
  const [existingFieldsByDataViewMap, setExistingFieldsByDataViewMap] = (0, _react.useState)(globalMap$.getValue());
  (0, _react.useEffect)(() => {
    const subscription = globalMap$.subscribe(data => {
      if (mountedRef.current && Object.keys(data).length > 0) {
        setExistingFieldsByDataViewMap(savedData => ({
          ...savedData,
          ...data
        }));
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [setExistingFieldsByDataViewMap, mountedRef]);
  const hasFieldData = (0, _react.useCallback)((dataViewId, fieldName) => {
    const info = existingFieldsByDataViewMap[dataViewId];
    if ((info === null || info === void 0 ? void 0 : info.fetchStatus) === _types.ExistenceFetchStatus.succeeded) {
      return (info === null || info === void 0 ? void 0 : info.hasDataViewRestrictions) || Boolean(info === null || info === void 0 ? void 0 : info.existingFieldsByFieldNameMap[fieldName]);
    }
    return true;
  }, [existingFieldsByDataViewMap]);
  const getFieldsExistenceInfo = (0, _react.useCallback)(dataViewId => {
    return dataViewId ? existingFieldsByDataViewMap[dataViewId] : unknownInfo;
  }, [existingFieldsByDataViewMap]);
  const getFieldsExistenceStatus = (0, _react.useCallback)(dataViewId => {
    var _getFieldsExistenceIn;
    return ((_getFieldsExistenceIn = getFieldsExistenceInfo(dataViewId)) === null || _getFieldsExistenceIn === void 0 ? void 0 : _getFieldsExistenceIn.fetchStatus) || _types.ExistenceFetchStatus.unknown;
  }, [getFieldsExistenceInfo]);
  const isFieldsExistenceInfoUnavailable = (0, _react.useCallback)(dataViewId => {
    const info = getFieldsExistenceInfo(dataViewId);
    return Boolean((info === null || info === void 0 ? void 0 : info.fetchStatus) === _types.ExistenceFetchStatus.failed || (info === null || info === void 0 ? void 0 : info.hasDataViewRestrictions));
  }, [getFieldsExistenceInfo]);
  (0, _react.useEffect)(() => {
    return () => {
      mountedRef.current = false;
    };
  }, [mountedRef]);
  return (0, _react.useMemo)(() => ({
    hasFieldData,
    getFieldsExistenceStatus,
    isFieldsExistenceInfoUnavailable
  }), [hasFieldData, getFieldsExistenceStatus, isFieldsExistenceInfoUnavailable]);
};
exports.useExistingFieldsReader = useExistingFieldsReader;
const resetExistingFieldsCache = () => {
  globalMap$.next(initialData);
};
exports.resetExistingFieldsCache = resetExistingFieldsCache;
function getDataViewsHash(dataViews) {
  return dataViews
  // From Lens it's coming as IndexPattern type and not the real DataView type
  .map(dataView => {
    var _dataView$fields$leng, _dataView$fields;
    return `${dataView.id}:${dataView.title}:${dataView.timeFieldName || 'no-timefield'}:${(_dataView$fields$leng = (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : _dataView$fields.length) !== null && _dataView$fields$leng !== void 0 ? _dataView$fields$leng : 0 // adding a field will also trigger a refetch of fields existence data
    }`;
  }).join(',');
}

// Wrapper around buildEsQuery, handling errors (e.g. because a query can't be parsed) by
// returning a query dsl object not matching anything
async function buildSafeEsQuery(dataView, query, filters, queryConfig) {
  const buildEsQuery = await getBuildEsQueryAsync();
  try {
    return buildEsQuery(dataView, query, filters, queryConfig);
  } catch (e) {
    return {
      bool: {
        must_not: {
          match_all: {}
        }
      }
    };
  }
}
function booleanMap(keys) {
  return keys.reduce((acc, key) => {
    acc[key] = true;
    return acc;
  }, {});
}