"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTriggerConstant = getTriggerConstant;
exports.getVisualizeInformation = getVisualizeInformation;
exports.triggerVisualizeActions = triggerVisualizeActions;
exports.triggerVisualizeActionsTextBasedLanguages = triggerVisualizeActionsTextBasedLanguages;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getTriggerConstant(type) {
  return type === _public2.KBN_FIELD_TYPES.GEO_POINT || type === _public2.KBN_FIELD_TYPES.GEO_SHAPE ? _public.VISUALIZE_GEO_FIELD_TRIGGER : _public.VISUALIZE_FIELD_TRIGGER;
}
function getTrigger(type) {
  return type === _public2.KBN_FIELD_TYPES.GEO_POINT || type === _public2.KBN_FIELD_TYPES.GEO_SHAPE ? _public.visualizeGeoFieldTrigger : _public.visualizeFieldTrigger;
}
async function getCompatibleActions(uiActions, fieldName, dataView, contextualFields = [], trigger) {
  const compatibleActions = await uiActions.getTriggerCompatibleActions(trigger, {
    dataViewSpec: dataView.toSpec(false),
    fieldName,
    contextualFields
  });
  return compatibleActions;
}
function triggerVisualizeActions(uiActions, field, contextualFields = [], originatingApp, dataView) {
  if (!dataView) return;
  const trigger = getTriggerConstant(field.type);
  const triggerOptions = {
    dataViewSpec: dataView.toSpec(false),
    fieldName: field.name,
    contextualFields,
    originatingApp
  };
  uiActions.getTrigger(trigger).exec(triggerOptions);
}
function triggerVisualizeActionsTextBasedLanguages(uiActions, contextualFields, originatingApp, dataView, query) {
  if (!dataView) return;
  const triggerOptions = {
    dataViewSpec: dataView.toSpec(false),
    fieldName: '',
    contextualFields,
    originatingApp,
    query
  };
  uiActions.getTrigger(_public.VISUALIZE_FIELD_TRIGGER).exec(triggerOptions);
}
/**
 * Returns the field name and potentially href of the field or the first multi-field
 * that has a compatible visualize uiAction.
 */
async function getVisualizeInformation(uiActions, field, dataView, contextualFields = [], multiFields = []) {
  if (field.name === '_id' || !(dataView !== null && dataView !== void 0 && dataView.id)) {
    // _id fields are not visualizeable in ES
    return undefined;
  }
  for (const f of [field, ...multiFields]) {
    if (!f.visualizable) {
      continue;
    }
    // Retrieve compatible actions for the specific field
    const actions = await getCompatibleActions(uiActions, f.name, dataView, contextualFields, getTriggerConstant(f.type));

    // if the field has compatible actions use this field for visualizing
    if (actions.length > 0) {
      var _actions$0$getHref, _actions$;
      const triggerOptions = {
        dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(false),
        fieldName: f.name,
        contextualFields,
        trigger: getTrigger(f.type)
      };
      return {
        field: f,
        // We use the href of the first action always. Multiple actions will only work
        // via the modal shown by triggerVisualizeActions that should be called via onClick.
        href: await ((_actions$0$getHref = (_actions$ = actions[0]).getHref) === null || _actions$0$getHref === void 0 ? void 0 : _actions$0$getHref.call(_actions$, triggerOptions))
      };
    }
  }
  return undefined;
}