"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNumberSummary = void 0;
exports.isNumberSummaryValid = isNumberSummaryValid;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldNumberSummary = ({
  dataView,
  field,
  numberSummary,
  'data-test-subj': dataTestSubject
}) => {
  if (!numberSummary || !isNumberSummaryValid(numberSummary)) {
    return null;
  }
  const formatter = dataView.getFormatterForField(field);
  const summaryTableItems = [{
    key: 'min',
    label: _i18n.i18n.translate('unifiedFieldList.fieldStats.numberSummary.minLabel', {
      defaultMessage: 'min'
    }),
    value: formatter.convert(numberSummary.minValue, 'text')
  }, {
    key: 'max',
    label: _i18n.i18n.translate('unifiedFieldList.fieldStats.numberSummary.maxLabel', {
      defaultMessage: 'max'
    }),
    value: formatter.convert(numberSummary.maxValue, 'text')
  }];
  const summaryTableColumns = [{
    field: 'label',
    name: '',
    align: _eui.LEFT_ALIGNMENT
  }, {
    field: 'value',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement("strong", null, v),
    align: _eui.RIGHT_ALIGNMENT
  }];
  const summaryTableTitle = _i18n.i18n.translate('unifiedFieldList.fieldStats.numberSummary.summaryTableTitle', {
    defaultMessage: 'Summary'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    compressed: true,
    items: summaryTableItems,
    columns: summaryTableColumns,
    tableCaption: summaryTableTitle,
    "data-test-subj": `${dataTestSubject}-numberSummary`,
    responsive: false,
    css: (0, _react2.css)`
        & .euiTableHeaderCell {
          ${(0, _eui.euiScreenReaderOnly)()}
        }
        & .euiTableRowCell {
          border-top: none;
        }
      `
  });
};
exports.FieldNumberSummary = FieldNumberSummary;
function isNumberSummaryValid(numberSummary) {
  return typeof (numberSummary === null || numberSummary === void 0 ? void 0 : numberSummary.minValue) === 'number' && typeof (numberSummary === null || numberSummary === void 0 ? void 0 : numberSummary.maxValue) === 'number';
}