"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./field_popover.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPopover = ({
  isOpen,
  closePopover,
  renderHeader,
  renderContent,
  ...otherPopoverProps
}) => {
  let header = null;
  let content = null;
  if (isOpen) {
    try {
      header = (renderHeader === null || renderHeader === void 0 ? void 0 : renderHeader()) || null;
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
    }
    try {
      content = (renderContent === null || renderContent === void 0 ? void 0 : renderContent()) || null;
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    ownFocus: true,
    isOpen: isOpen,
    closePopover: closePopover,
    display: "block",
    anchorPosition: "rightUp",
    "data-test-subj": "fieldPopover",
    panelClassName: "unifiedFieldList__fieldPopover__fieldPopoverPanel"
  }, otherPopoverProps), isOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content && header ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, header) : header, content));
};
exports.FieldPopover = FieldPopover;