"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _field_name_search = require("./field_name_search");
var _field_type_filter = require("./field_type_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Field list filters which include search by field name and filtering by field type.
 * Use in combination with `useGroupedFields` hook. Or for more control - `useFieldFilters()` hook.
 * @param dataTestSubject
 * @param docLinks
 * @param selectedFieldTypes
 * @param allFields
 * @param getCustomFieldType
 * @param onSupportedFieldFilter
 * @param onChangeFieldTypes
 * @param nameFilter
 * @param screenReaderDescriptionId
 * @param onChangeNameFilter
 * @public
 * @constructor
 */
function InnerFieldListFilters({
  'data-test-subj': dataTestSubject = 'fieldListFilters',
  docLinks,
  selectedFieldTypes,
  allFields,
  getCustomFieldType,
  onSupportedFieldFilter,
  onChangeFieldTypes,
  nameFilter,
  screenReaderDescriptionId,
  onChangeNameFilter
}) {
  return /*#__PURE__*/_react.default.createElement(_field_name_search.FieldNameSearch, {
    "data-test-subj": dataTestSubject,
    append: allFields && selectedFieldTypes && onChangeFieldTypes ? /*#__PURE__*/_react.default.createElement(_field_type_filter.FieldTypeFilter, {
      "data-test-subj": dataTestSubject,
      docLinks: docLinks,
      selectedFieldTypes: selectedFieldTypes,
      allFields: allFields,
      getCustomFieldType: getCustomFieldType,
      onSupportedFieldFilter: onSupportedFieldFilter,
      onChange: onChangeFieldTypes
    }) : undefined,
    nameFilter: nameFilter,
    screenReaderDescriptionId: screenReaderDescriptionId,
    onChange: onChangeNameFilter
  });
}
const FieldListFilters = /*#__PURE__*/_react.default.memo(InnerFieldListFilters);

// Necessary for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FieldListFilters;
exports.default = _default;
module.exports = exports.default;