"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldCategorizeButton = void 0;
exports.getFieldCategorizeButton = getFieldCategorizeButton;
var _react = _interopRequireDefault(require("react"));
var _analytics = require("@kbn/analytics");
var _field_categorize_button_inner = require("./field_categorize_button_inner");
var _categorize_trigger_utils = require("./categorize_trigger_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldCategorizeButton = /*#__PURE__*/_react.default.memo(({
  field,
  dataView,
  trackUiMetric,
  originatingApp,
  uiActions,
  buttonProps,
  closePopover
}) => {
  const handleVisualizeLinkClick = async event => {
    // regular link click. let the uiActions code handle the navigation and show popup if needed
    event.preventDefault();
    const triggerVisualization = updatedDataView => {
      trackUiMetric === null || trackUiMetric === void 0 ? void 0 : trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'categorize_link_click');
      (0, _categorize_trigger_utils.triggerCategorizeActions)(uiActions, field, originatingApp, updatedDataView);
    };
    triggerVisualization(dataView);
    if (closePopover) {
      closePopover();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_field_categorize_button_inner.FieldCategorizeButtonInner, {
    fieldName: field.name,
    handleVisualizeLinkClick: handleVisualizeLinkClick,
    buttonProps: buttonProps
  });
});
exports.FieldCategorizeButton = FieldCategorizeButton;
async function getFieldCategorizeButton(props) {
  const showButton = await (0, _categorize_trigger_utils.canCategorize)(props.uiActions, props.field, props.dataView);
  return showButton ? /*#__PURE__*/_react.default.createElement(FieldCategorizeButton, props) : null;
}